/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.CustomMimeTypesFileTypeDetector;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class CustomMimeTypesFileTypeDetectorTest {
    CustomMimeTypesFileTypeDetectorTest() {
    }

    @Test
    void should_return_a_mime_type_from_default_mapping_from_path() {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        Path path = Path.of("/foo/bar/index.html", new String[0]);
        String mimeType = detector.probeContentType(path);
        Assertions.assertThat((String)mimeType).isEqualTo("text/html");
    }

    @Test
    void should_return_a_mime_type_from_default_mapping_from_uri() {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        URI uri = URI.create("https://foo.com/bar/style.css");
        String mimeType = detector.probeContentType(uri);
        Assertions.assertThat((String)mimeType).isEqualTo("text/css");
    }

    @Test
    void should_return_a_mime_type_from_default_mapping_from_string() {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        String mimeType = detector.probeContentType("README.md");
        Assertions.assertThat((String)mimeType).isEqualTo("text/x-markdown");
    }

    @Test
    void can_provide_custom_mapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("abcd", "text/abcd");
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector(mapping);
        String mimeType = detector.probeContentType("foo.abcd");
        Assertions.assertThat((String)mimeType).isEqualTo("text/abcd");
    }

    @Test
    void should_return_null_when_no_mapping_exist_from_path() {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        String mimeType = detector.probeContentType("foo.banana");
        Assertions.assertThat((String)mimeType).isNull();
    }

    @Test
    void should_return_null_when_no_mapping_exist_from_uri() {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        String mimeType = detector.probeContentType(URI.create("https://foo.bar.com/baz.yui"));
        Assertions.assertThat((String)mimeType).isNull();
    }

    @Test
    void should_return_mime_type_from_website_from_uri() {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        String mimeType = detector.probeContentType(URI.create("https://docs.langchain4j.dev/logo.svg"));
        Assertions.assertThat((String)mimeType).isEqualTo("image/svg+xml");
    }

    @ParameterizedTest
    @ValueSource(strings={"http://example.org/cat", "http://example.org/cat.banana", "http://example.org/some.path/cat", "http://example.org/cat?query=dog.png"})
    void should_fail_to_detect_mime_type(String url) throws MalformedURLException, URISyntaxException {
        CustomMimeTypesFileTypeDetector detector = new CustomMimeTypesFileTypeDetector();
        String mimeType = detector.probeContentType(new URL(url).toURI());
        Assertions.assertThat((String)mimeType).isNull();
    }
}

