/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import dev.langchain4j.internal.JacksonJsonCodec;
import dev.langchain4j.internal.Json;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JsonCodecTest {
    private static final String PERSON_JSON = "{\n    \"name\": \"Klaus\",\n    \"age\": 42\n}\n";

    JsonCodecTest() {
    }

    static List<Json.JsonCodec> codecs() {
        return List.of(new JacksonJsonCodec());
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record(Json.JsonCodec codec) {
        Person person = (Person)codec.fromJson(PERSON_JSON, Person.class);
        Assertions.assertThat((String)person.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)person.age()).isEqualTo(42);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_missing_fields(Json.JsonCodec codec) {
        String json = "{}";
        Person pojo = (Person)codec.fromJson(json, Person.class);
        Assertions.assertThat((String)pojo.name()).isNull();
        Assertions.assertThat((int)pojo.age()).isEqualTo(0);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_different_field_order(Json.JsonCodec codec) {
        String json = "{\n    \"age\": 42,\n    \"name\": \"Klaus\"\n}\n";
        Person pojo = (Person)codec.fromJson(json, Person.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age()).isEqualTo(42);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void should_fail_on_unknown_fields_by_default(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"age\": 42,\n    \"married\": false\n}\n";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(json, Person.class)).isExactlyInstanceOf(RuntimeException.class)).hasCauseExactlyInstanceOf(UnrecognizedPropertyException.class).hasMessageContaining("married");
        @JsonIgnoreProperties(ignoreUnknown=true)
        record LenientPersonRecord(String name, int age) {
        }
        LenientPersonRecord lenientPerson = (LenientPersonRecord)codec.fromJson(json, LenientPersonRecord.class);
        Assertions.assertThat((Object)lenientPerson).isEqualTo((Object)new LenientPersonRecord("Klaus", 42));
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_null_value(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"age\": null\n}\n";
        Person pojo = (Person)codec.fromJson(json, Person.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age()).isEqualTo(0);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_wrong_type(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"age\": \"42\"\n}\n";
        Person pojo = (Person)codec.fromJson(json, Person.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age()).isEqualTo(42);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_wrong_type_2(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"age\": 42.0\n}\n";
        Person pojo = (Person)codec.fromJson(json, Person.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age()).isEqualTo(42);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_nested_record(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"address\": {\n        \"city\": \"Langley Falls\"\n    }\n}\n";
        PersonRecordWithNestedRecord pojo = (PersonRecordWithNestedRecord)codec.fromJson(json, PersonRecordWithNestedRecord.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((String)pojo.address().city()).isEqualTo("Langley Falls");
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_missing_collections(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\"\n}\n";
        PersonRecordWithCollections pojo = (PersonRecordWithCollections)codec.fromJson(json, PersonRecordWithCollections.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat(pojo.collection()).isNull();
        Assertions.assertThat(pojo.list()).isNull();
        Assertions.assertThat(pojo.set()).isNull();
        Assertions.assertThat((Object[])pojo.array()).isNull();
        Assertions.assertThat(pojo.map()).isNull();
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_empty_collections(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"collection\": [],\n    \"list\": [],\n    \"set\": [],\n    \"array\": [],\n    \"map\": {}\n}\n";
        PersonRecordWithCollections pojo = (PersonRecordWithCollections)codec.fromJson(json, PersonRecordWithCollections.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat(pojo.collection()).isEmpty();
        Assertions.assertThat(pojo.list()).isEmpty();
        Assertions.assertThat(pojo.set()).isEmpty();
        Assertions.assertThat((Object[])pojo.array()).isEmpty();
        Assertions.assertThat(pojo.map()).isEmpty();
    }

    @Disabled(value="optional fields are currently not supported")
    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_optional_present(Json.JsonCodec codec) {
        PersonRecordWithOptional pojo = (PersonRecordWithOptional)codec.fromJson(PERSON_JSON, PersonRecordWithOptional.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat(pojo.age()).hasValue((Object)42);
    }

    @Disabled(value="optional fields are currently not supported")
    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_optional_absent(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\"\n}\n";
        PersonRecordWithOptional pojo = (PersonRecordWithOptional)codec.fromJson(json, PersonRecordWithOptional.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat(pojo.age()).isEmpty();
    }

    @Disabled(value="optional fields are currently not supported")
    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_optional_null(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"age\": null\n}\n";
        PersonRecordWithOptional pojo = (PersonRecordWithOptional)codec.fromJson(json, PersonRecordWithOptional.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat(pojo.age()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_inner_record(Json.JsonCodec codec) {
        record PersonInnerRecord(String name, int age) {
        }
        PersonInnerRecord pojo = (PersonInnerRecord)codec.fromJson(PERSON_JSON, PersonInnerRecord.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age()).isEqualTo(42);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_validation(Json.JsonCodec codec) {
        String json = "{\n    \"name\": \"Klaus\",\n    \"age\": -1\n}\n";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(json, PersonRecordWithValidation.class)).isExactlyInstanceOf(RuntimeException.class)).hasCauseExactlyInstanceOf(ValueInstantiationException.class).hasRootCauseExactlyInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("age must be positive");
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_record_with_custom_ctor(Json.JsonCodec codec) {
        PersonRecordCustomCtor pojo = (PersonRecordCustomCtor)codec.fromJson("{\n    \"name\": \"Klaus\"\n}\n", PersonRecordCustomCtor.class);
        Assertions.assertThat((String)pojo.name()).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age()).isEqualTo(0);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void test_static_nested_class(Json.JsonCodec codec) {
        PersonStaticNestedClass pojo = (PersonStaticNestedClass)codec.fromJson(PERSON_JSON, PersonStaticNestedClass.class);
        Assertions.assertThat((String)pojo.name).isEqualTo("Klaus");
        Assertions.assertThat((int)pojo.age).isEqualTo(42);
    }

    record Person(String name, int age) {
    }

    record PersonRecordWithNestedRecord(String name, Address address) {
    }

    record Address(String city) {
    }

    record PersonRecordWithCollections(String name, Collection<String> collection, List<String> list, Set<Object> set, String[] array, Map<Object, Object> map) {
    }

    record PersonRecordWithOptional(String name, Optional<Integer> age) {
    }

    record PersonRecordCustomCtor(String name, int age) {
        public PersonRecordCustomCtor(String name) {
            this(name, 99);
        }
    }

    static class PersonStaticNestedClass {
        private String name;
        private int age;

        PersonStaticNestedClass() {
        }
    }

    record PersonRecordWithValidation(String name, int age) {
        public PersonRecordWithValidation {
            if (age < 0) {
                throw new IllegalArgumentException("age must be positive");
            }
        }
    }
}

