/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.internal.Json;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonTest {
    JsonTest() {
    }

    @Test
    void conversionToJsonAndFromJsonWorks() {
        TestData testData = new TestData();
        testData.setSampleDate(LocalDate.of(2023, 1, 15));
        testData.setSampleDateTime(LocalDateTime.of(2023, 1, 15, 10, 20));
        testData.setSomeValue("value");
        String json = Json.toJson((Object)testData);
        Assertions.assertThat((String)json).isEqualToIgnoringWhitespace((CharSequence)"{\n  \"sampleDate\": \"2023-01-15\",\n  \"sampleDateTime\": \"2023-01-15T10:20:00\",\n  \"some_value\": \"value\"\n}");
        TestData deserializedData = (TestData)Json.fromJson((String)json, TestData.class);
        Assertions.assertThat((LocalDate)deserializedData.getSampleDate()).isEqualTo((Object)testData.getSampleDate());
        Assertions.assertThat((LocalDateTime)deserializedData.getSampleDateTime()).isEqualTo((Object)testData.getSampleDateTime());
        Assertions.assertThat((String)deserializedData.getSomeValue()).isEqualTo(testData.getSomeValue());
    }

    private static class TestData {
        private LocalDate sampleDate;
        private LocalDateTime sampleDateTime;
        @JsonProperty(value="some_value")
        private String someValue;

        private TestData() {
        }

        LocalDate getSampleDate() {
            return this.sampleDate;
        }

        void setSampleDate(LocalDate sampleDate) {
            this.sampleDate = sampleDate;
        }

        LocalDateTime getSampleDateTime() {
            return this.sampleDateTime;
        }

        void setSampleDateTime(LocalDateTime sampleDateTime) {
            this.sampleDateTime = sampleDateTime;
        }

        String getSomeValue() {
            return this.someValue;
        }

        void setSomeValue(String someValue) {
            this.someValue = someValue;
        }
    }
}

