/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ChatLanguageModelTest
implements WithAssertions {
    ChatLanguageModelTest() {
    }

    @Test
    void generate() {
        UpperCaseEchoModel model = new UpperCaseEchoModel();
        this.assertThat(model.chat("how are you?")).isEqualTo("HOW ARE YOU?");
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(new UserMessage("Hello"));
        messages.add(new AiMessage("Hi"));
        messages.add(new UserMessage("How are you?"));
        ChatResponse response2 = model.chat(messages);
        this.assertThat(response2.aiMessage().text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response2.tokenUsage()).isNull();
        this.assertThat((Comparable)response2.finishReason()).isNull();
        ChatResponse response3 = model.chat(new ChatMessage[]{new UserMessage("Hello"), new AiMessage("Hi"), new UserMessage("How are you?")});
        this.assertThat(response3.aiMessage().text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response3.tokenUsage()).isNull();
        this.assertThat((Comparable)response3.finishReason()).isNull();
    }

    public static class UpperCaseEchoModel
    implements ChatLanguageModel {
        public ChatResponse doChat(ChatRequest chatRequest) {
            List messages = chatRequest.messages();
            ChatMessage lastMessage = (ChatMessage)messages.get(messages.size() - 1);
            return ChatResponse.builder().aiMessage(new AiMessage(lastMessage.text().toUpperCase(Locale.ROOT))).build();
        }
    }
}

