/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.TestStreamingChatResponseHandler;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

public abstract class StreamingChatModelListenerIT {
    protected abstract StreamingChatLanguageModel createModel(ChatModelListener var1);

    protected abstract String modelName();

    protected Double temperature() {
        return 0.7;
    }

    protected Double topP() {
        return 1.0;
    }

    protected Integer maxTokens() {
        return 7;
    }

    protected abstract StreamingChatLanguageModel createFailingModel(ChatModelListener var1);

    protected abstract Class<? extends Exception> expectedExceptionClass();

    @Test
    void should_listen_request_and_response() {
        final AtomicReference requestReference = new AtomicReference();
        final AtomicInteger onRequestInvocations = new AtomicInteger();
        final AtomicReference responseReference = new AtomicReference();
        final AtomicInteger onResponseInvocations = new AtomicInteger();
        ChatModelListener listener = new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                requestReference.set(requestContext.request());
                onRequestInvocations.incrementAndGet();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)requestContext.modelProvider()).isNotNull()).isNotEqualTo((Object)ModelProvider.OTHER);
                requestContext.attributes().put("id", "12345");
            }

            public void onResponse(ChatModelResponseContext responseContext) {
                responseReference.set(responseContext.response());
                onResponseInvocations.incrementAndGet();
                Assertions.assertThat((Object)responseContext.request()).isEqualTo(requestReference.get());
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)responseContext.modelProvider()).isNotNull()).isNotEqualTo((Object)ModelProvider.OTHER);
                Assertions.assertThat((Map)responseContext.attributes()).containsEntry((Object)"id", (Object)"12345");
            }

            public void onError(ChatModelErrorContext errorContext) {
                Assertions.fail((String)("onError() must not be called. Exception: " + errorContext.error().getMessage()));
            }
        };
        StreamingChatLanguageModel model = this.createModel(listener);
        UserMessage userMessage = UserMessage.from((String)"hello");
        ChatRequest.Builder chatRequestBuilder = ChatRequest.builder().messages(new ChatMessage[]{userMessage});
        ToolSpecification toolSpecification = null;
        if (this.supportsTools()) {
            toolSpecification = ToolSpecification.builder().name("add").parameters(JsonObjectSchema.builder().addIntegerProperty("a").addIntegerProperty("b").build()).build();
            chatRequestBuilder.toolSpecifications(new ToolSpecification[]{toolSpecification});
        }
        ChatRequest chatRequest = chatRequestBuilder.build();
        TestStreamingChatResponseHandler handler = new TestStreamingChatResponseHandler();
        model.chat(chatRequest, (StreamingChatResponseHandler)handler);
        AiMessage aiMessage = handler.get().aiMessage();
        ChatModelRequest request = (ChatModelRequest)requestReference.get();
        Assertions.assertThat((String)request.model()).isEqualTo(this.modelName());
        Assertions.assertThat((Double)request.temperature()).isCloseTo(this.temperature(), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((Double)request.topP()).isEqualTo(this.topP());
        Assertions.assertThat((Integer)request.maxTokens()).isEqualTo((Object)this.maxTokens());
        Assertions.assertThat((List)request.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        if (this.supportsTools()) {
            Assertions.assertThat((List)request.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        }
        Assertions.assertThat((AtomicInteger)onRequestInvocations).hasValue(1);
        ChatModelResponse response2 = (ChatModelResponse)responseReference.get();
        if (this.assertResponseId()) {
            Assertions.assertThat((String)response2.id()).isNotBlank();
        }
        if (this.assertResponseModel()) {
            Assertions.assertThat((String)response2.model()).isNotBlank();
        }
        if (this.assertTokenUsage()) {
            Assertions.assertThat((Integer)response2.tokenUsage().inputTokenCount()).isGreaterThan(0);
            Assertions.assertThat((Integer)response2.tokenUsage().outputTokenCount()).isGreaterThan(0);
            Assertions.assertThat((Integer)response2.tokenUsage().totalTokenCount()).isGreaterThan(0);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)response2.finishReason()).isNotNull();
        }
        Assertions.assertThat((Object)response2.aiMessage()).isEqualTo((Object)aiMessage);
        Assertions.assertThat((AtomicInteger)onResponseInvocations).hasValue(1);
    }

    protected boolean supportsTools() {
        return true;
    }

    protected boolean assertResponseId() {
        return true;
    }

    protected boolean assertResponseModel() {
        return true;
    }

    protected boolean assertTokenUsage() {
        return true;
    }

    protected boolean assertFinishReason() {
        return true;
    }

    @Test
    protected void should_listen_error() throws Exception {
        final AtomicReference requestReference = new AtomicReference();
        final AtomicInteger onRequestInvocations = new AtomicInteger();
        final AtomicReference errorReference = new AtomicReference();
        final AtomicInteger onErrorInvocations = new AtomicInteger();
        ChatModelListener listener = new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                requestReference.set(requestContext.request());
                onRequestInvocations.incrementAndGet();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)requestContext.modelProvider()).isNotNull()).isNotEqualTo((Object)ModelProvider.OTHER);
                requestContext.attributes().put("id", "12345");
            }

            public void onResponse(ChatModelResponseContext responseContext) {
                Assertions.fail((String)"onResponse() must not be called");
            }

            public void onError(ChatModelErrorContext errorContext) {
                errorReference.set(errorContext.error());
                onErrorInvocations.incrementAndGet();
                Assertions.assertThat((Object)errorContext.request()).isEqualTo(requestReference.get());
                Assertions.assertThat((Object)errorContext.partialResponse()).isNull();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)errorContext.modelProvider()).isNotNull()).isNotEqualTo((Object)ModelProvider.OTHER);
                Assertions.assertThat((Map)errorContext.attributes()).containsEntry((Object)"id", (Object)"12345");
            }
        };
        StreamingChatLanguageModel model = this.createFailingModel(listener);
        String userMessage = "this message will fail";
        final CompletableFuture future = new CompletableFuture();
        StreamingChatResponseHandler handler = new StreamingChatResponseHandler(){

            public void onPartialResponse(String partialResponse) {
                Assertions.fail((String)"onPartialResponse() must not be called");
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                Assertions.fail((String)"onCompleteResponse() must not be called");
            }

            public void onError(Throwable error) {
                future.complete(error);
            }
        };
        model.chat(userMessage, handler);
        Throwable throwable = (Throwable)future.get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(this.expectedExceptionClass());
        Assertions.assertThat((Throwable)((Throwable)errorReference.get())).isSameAs((Object)throwable);
        Assertions.assertThat((AtomicInteger)onRequestInvocations).hasValue(1);
        Assertions.assertThat((AtomicInteger)onErrorInvocations).hasValue(1);
    }
}

