/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.input.Prompt;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TokenCountEstimatorTest
implements WithAssertions {
    TokenCountEstimatorTest() {
    }

    @Test
    void test() {
        WhitespaceSplitTokenCountEstimator estimator = new WhitespaceSplitTokenCountEstimator();
        this.assertThat(estimator.estimateTokenCount("foo bar, baz")).isEqualTo(3);
        this.assertThat(estimator.estimateTokenCount(new UserMessage("foo bar, baz"))).isEqualTo(3);
        this.assertThat(estimator.estimateTokenCount(new Prompt("foo bar, baz"))).isEqualTo(3);
        this.assertThat(estimator.estimateTokenCount(TextSegment.from((String)"foo bar, baz"))).isEqualTo(3);
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(new UserMessage("Hello, world!"));
        messages.add(new AiMessage("How are you?"));
        this.assertThat(estimator.estimateTokenCount(messages)).isEqualTo(5);
    }

    public static class WhitespaceSplitTokenCountEstimator
    implements TokenCountEstimator {
        public int estimateTokenCount(List<ChatMessage> messages) {
            return messages.stream().mapToInt(message -> message.text().split("\\s+").length).sum();
        }
    }
}

