/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request.json;

import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.structured.Description;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonSchemaElementHelperTest {
    JsonSchemaElementHelperTest() {
    }

    @Test
    void is_custom_class() {
        Assertions.assertThat((boolean)JsonSchemaElementHelper.isCustomClass(CustomClass.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementHelper.isCustomClass(Integer.class)).isFalse();
        Assertions.assertThat((boolean)JsonSchemaElementHelper.isCustomClass(LocalDateTime.class)).isFalse();
    }

    @Test
    void should_not_use_reference_schema_when_no_recursion() {
        Class<Order> clazz = Order.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementHelper.jsonSchemaElementFrom(clazz, null, null, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonObjectSchema.builder().addProperty("billingAddress", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("city").required(new String[]{"city"}).build()).addProperty("shippingAddress", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("city").required(new String[]{"city"}).build()).required(new String[]{"billingAddress", "shippingAddress"}).build());
    }

    @Test
    void should_set_default_description_for_uuid() {
        Class<UUID> clazz = UUID.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementHelper.jsonSchemaElementFrom(clazz, null, null, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonStringSchema.builder().description("String in a UUID format").build());
    }

    @Test
    void should_set_default_description_for_uuid_in_class() {
        Class<MyClassWithUuid> clazz = MyClassWithUuid.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementHelper.jsonSchemaElementFrom(clazz, null, null, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonObjectSchema.builder().addStringProperty("uuid", "String in a UUID format").required(new String[]{"uuid"}).build());
    }

    @Test
    void should_use_non_null_description_for_uuid() {
        Class<MyClassWithDescribedUuid> clazz = MyClassWithDescribedUuid.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementHelper.jsonSchemaElementFrom(clazz, null, null, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonObjectSchema.builder().addStringProperty("uuid", "My UUID").required(new String[]{"uuid"}).build());
    }

    static class CustomClass {
        CustomClass() {
        }
    }

    static class Order {
        Address billingAddress;
        Address shippingAddress;

        Order() {
        }
    }

    static class MyClassWithUuid {
        UUID uuid;

        MyClassWithUuid() {
        }
    }

    static class MyClassWithDescribedUuid {
        @Description(value={"My UUID"})
        UUID uuid;

        MyClassWithDescribedUuid() {
        }
    }

    static class Address {
        String city;

        Address() {
        }
    }
}

