/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class EmbeddingModelTest
implements WithAssertions {
    EmbeddingModelTest() {
    }

    @Test
    void test() {
        EmbeddingModelImpl model = new EmbeddingModelImpl();
        String abcDef = "abc def";
        Response response2 = model.embed(abcDef);
        this.assertThat(((Embedding)response2.content()).vector()).containsExactly(new float[]{abcDef.length(), abcDef.hashCode()});
        this.assertThat((Comparable)response2.finishReason()).isEqualTo((Object)FinishReason.STOP);
        this.assertThat(response2.tokenUsage()).isEqualTo((Object)new TokenUsage(Integer.valueOf(abcDef.length())));
        this.assertThat(model.dimension()).isEqualTo(0);
    }

    @Test
    void broken() {
        BrokenEmbeddingModelImpl model = new BrokenEmbeddingModelImpl();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> model.embed("abc def")).withMessageContaining("Expected a single embedding, but got 2");
        this.assertThat(model.dimension()).isEqualTo(0);
    }

    public static class EmbeddingModelImpl
    implements EmbeddingModel {
        public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
            List embeddings = textSegments.stream().map(ts -> new Embedding(new float[]{ts.text().length(), ts.text().hashCode()})).collect(Collectors.toList());
            int tokenUsage = textSegments.stream().mapToInt(ts -> ts.text().length()).sum();
            return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(tokenUsage)), (FinishReason)FinishReason.STOP);
        }

        public int dimension() {
            return 0;
        }
    }

    public static class BrokenEmbeddingModelImpl
    implements EmbeddingModel {
        public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
            ArrayList<TextSegment> doubledList = new ArrayList<TextSegment>(textSegments);
            doubledList.addAll(textSegments);
            return new EmbeddingModelImpl().embedAll(doubledList);
        }

        public int dimension() {
            return 0;
        }
    }
}

