/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.language;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.language.TokenCountEstimator;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TokenCountEstimatorTest
implements WithAssertions {
    TokenCountEstimatorTest() {
    }

    @Test
    void test() {
        WhitespaceSplitTokenCountEstimator estimator = new WhitespaceSplitTokenCountEstimator();
        this.assertThat(estimator.estimateTokenCount("foo bar, baz")).isEqualTo(3);
        this.assertThat(estimator.estimateTokenCount(new Prompt("foo bar, baz"))).isEqualTo(3);
        this.assertThat(estimator.estimateTokenCount(TextSegment.from((String)"foo bar, baz"))).isEqualTo(3);
    }

    public static class WhitespaceSplitTokenCountEstimator
    implements TokenCountEstimator {
        public int estimateTokenCount(String text) {
            return text.split("\\s+").length;
        }
    }
}

