/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.injector;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.injector.ContentInjector;
import dev.langchain4j.rag.content.injector.DefaultContentInjector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class DefaultContentInjectorTest {
    DefaultContentInjectorTest() {
    }

    @Test
    void should_not_inject_when_no_content() {
        UserMessage userMessage = UserMessage.from((String)"Tell me about bananas.");
        List contents = Collections.emptyList();
        DefaultContentInjector injector = new DefaultContentInjector();
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((Object)injected).isEqualTo((Object)userMessage);
    }

    @Test
    void should_inject_single_content() {
        UserMessage userMessage = UserMessage.from((String)"Tell me about bananas.");
        List<Content> contents = Collections.singletonList(Content.from((String)"Bananas are awesome!"));
        DefaultContentInjector injector = new DefaultContentInjector();
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((String)injected.text()).isEqualTo("Tell me about bananas.\n\nAnswer using the following information:\nBananas are awesome!".stripIndent());
    }

    @Test
    void should_inject_single_content_with_userName() {
        UserMessage userMessage = UserMessage.from((String)"ape", (String)"Tell me about bananas.");
        List<Content> contents = Collections.singletonList(Content.from((String)"Bananas are awesome!"));
        DefaultContentInjector injector = new DefaultContentInjector();
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((String)injected.text()).isEqualTo("Tell me about bananas.\n\nAnswer using the following information:\nBananas are awesome!");
        Assertions.assertThat((String)injected.name()).isEqualTo("ape");
    }

    @Test
    void should_inject_single_content_with_metadata() {
        UserMessage userMessage = UserMessage.from((String)"Tell me about bananas.");
        TextSegment segment = TextSegment.from((String)"Bananas are awesome!", (Metadata)Metadata.from((String)"source", (String)"trust me bro"));
        List<Content> contents = Collections.singletonList(Content.from((TextSegment)segment));
        List<String> metadataKeysToInclude = Collections.singletonList("source");
        DefaultContentInjector injector = new DefaultContentInjector(metadataKeysToInclude);
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((String)injected.text()).isEqualTo("Tell me about bananas.\n\nAnswer using the following information:\ncontent: Bananas are awesome!\nsource: trust me bro");
    }

    @Test
    void should_inject_multiple_contents() {
        UserMessage userMessage = UserMessage.from((String)"Tell me about bananas.");
        List<Content> contents = Arrays.asList(Content.from((String)"Bananas are awesome!"), Content.from((String)"Bananas are healthy!"));
        DefaultContentInjector injector = new DefaultContentInjector();
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((String)injected.text()).isEqualTo("Tell me about bananas.\n\nAnswer using the following information:\nBananas are awesome!\n\nBananas are healthy!");
    }

    @ParameterizedTest
    @MethodSource
    void should_inject_multiple_contents_with_multiple_metadata_entries(Function<List<String>, ContentInjector> contentInjectorProvider) {
        UserMessage userMessage = UserMessage.from((String)"Tell me about bananas.");
        TextSegment segment1 = TextSegment.from((String)"Bananas are awesome!", (Metadata)Metadata.from((String)"source", (String)"trust me bro").put("date", "today"));
        TextSegment segment2 = TextSegment.from((String)"Bananas are healthy!", (Metadata)Metadata.from((String)"source", (String)"my doctor").put("reliability", "100%"));
        List<Content> contents = Arrays.asList(Content.from((TextSegment)segment1), Content.from((TextSegment)segment2));
        List<String> metadataKeysToInclude = Arrays.asList("source", "reliability", "date");
        ContentInjector injector = contentInjectorProvider.apply(metadataKeysToInclude);
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((String)injected.text()).isEqualTo("Tell me about bananas.\n\nAnswer using the following information:\ncontent: Bananas are awesome!\nsource: trust me bro\ndate: today\n\ncontent: Bananas are healthy!\nsource: my doctor\nreliability: 100%");
    }

    static Stream<Arguments> should_inject_multiple_contents_with_multiple_metadata_entries() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{DefaultContentInjector::new})).add(Arguments.of((Object[])new Object[]{metadataKeysToInclude -> DefaultContentInjector.builder().metadataKeysToInclude(metadataKeysToInclude).build()})).build();
    }

    @ParameterizedTest
    @MethodSource
    void should_inject_multiple_contents_with_custom_prompt_template(Function<PromptTemplate, ContentInjector> contentInjectorProvider) {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"{{userMessage}}\n{{contents}}");
        UserMessage userMessage = UserMessage.from((String)"Tell me about bananas.");
        List<Content> contents = Arrays.asList(Content.from((String)"Bananas are awesome!"), Content.from((String)"Bananas are healthy!"));
        ContentInjector injector = contentInjectorProvider.apply(promptTemplate);
        UserMessage injected = injector.inject(contents, userMessage);
        Assertions.assertThat((String)injected.text()).isEqualTo("Tell me about bananas.\nBananas are awesome!\n\nBananas are healthy!");
    }

    static Stream<Arguments> should_inject_multiple_contents_with_custom_prompt_template() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{DefaultContentInjector::new})).add(Arguments.of((Object[])new Object[]{promptTemplate -> DefaultContentInjector.builder().promptTemplate(promptTemplate).build()})).build();
    }
}

