/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.rag.query.Query;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class QueryTest {
    QueryTest() {
    }

    @Test
    void create() {
        String queryText = "query";
        Query query = Query.from((String)queryText);
        Assertions.assertThat((String)query.text()).isEqualTo(queryText);
        Assertions.assertThat((Object)query.metadata()).isNull();
    }

    @Test
    void create_with_metadata() {
        String queryText = "query";
        Metadata metadata = Metadata.from((UserMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query = Query.from((String)queryText, (Metadata)metadata);
        Assertions.assertThat((String)query.text()).isEqualTo(queryText);
        Assertions.assertThat((Object)query.metadata()).isSameAs((Object)metadata);
    }

    @Test
    void equals_hash_code() {
        Metadata metadata1 = Metadata.from((UserMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query1 = Query.from((String)"query", (Metadata)metadata1);
        Metadata metadata2 = Metadata.from((UserMessage)UserMessage.from((String)"another user message"), (Object)666, Arrays.asList(UserMessage.from((String)"Bye"), AiMessage.from((String)"Bye-bye")));
        Query query2 = Query.from((String)"query 2", (Metadata)metadata2);
        Metadata metadata3 = Metadata.from((UserMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query3 = Query.from((String)"query", (Metadata)metadata3);
        ((ObjectAssert)Assertions.assertThat((Object)query1).isNotEqualTo((Object)query2)).doesNotHaveSameHashCodeAs((Object)query2);
        ((ObjectAssert)Assertions.assertThat((Object)query1).isEqualTo((Object)query3)).hasSameHashCodeAs((Object)query3);
    }

    @Test
    void to_string() {
        Metadata metadata = Metadata.from((UserMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query = Query.from((String)"query", (Metadata)metadata);
        String toString = query.toString();
        Assertions.assertThat((String)toString).isEqualTo("Query { text = \"query\", metadata = Metadata { userMessage = UserMessage { name = null contents = [TextContent { text = \"user message\" }] }, chatMemoryId = 42, chatMemory = [UserMessage { name = null contents = [TextContent { text = \"Hello\" }] }, AiMessage { text = \"Hi, how can I help you today?\" toolExecutionRequests = null }] } }");
    }
}

