/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query.router;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.mock.ChatModelMock;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.rag.query.router.LanguageModelQueryRouter;
import dev.langchain4j.rag.query.router.QueryRouter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LanguageModelQueryRouterTest {
    @Mock
    ContentRetriever catArticlesRetriever;
    @Mock
    ContentRetriever dogArticlesRetriever;

    LanguageModelQueryRouterTest() {
    }

    @Test
    void should_route_to_single_retriever() {
        Query query = Query.from((String)"Do Labradors shed?");
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("2");
        LanguageModelQueryRouter router = new LanguageModelQueryRouter((ChatLanguageModel)model, retrieverToDescription);
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{this.dogArticlesRetriever});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Based on the user query, determine the most suitable data source(s) to retrieve relevant information from the following options:\n1: articles about cats\n2: articles about dogs\nIt is very important that your answer consists of either a single number or multiple numbers separated by commas and nothing else!\nUser query: Do Labradors shed?");
    }

    @Test
    void should_route_to_single_retriever_builder() {
        Query query = Query.from((String)"Do Labradors shed?");
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("2");
        LanguageModelQueryRouter router = LanguageModelQueryRouter.builder().chatLanguageModel((ChatLanguageModel)model).retrieverToDescription(retrieverToDescription).build();
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{this.dogArticlesRetriever});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Based on the user query, determine the most suitable data source(s) to retrieve relevant information from the following options:\n1: articles about cats\n2: articles about dogs\nIt is very important that your answer consists of either a single number or multiple numbers separated by commas and nothing else!\nUser query: Do Labradors shed?");
    }

    @Test
    void should_route_to_multiple_retrievers() {
        Query query = Query.from((String)"Which animal is the fluffiest?");
        HashMap<ContentRetriever, String> retrieverToDescription = new HashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("1, 2");
        LanguageModelQueryRouter router = new LanguageModelQueryRouter((ChatLanguageModel)model, retrieverToDescription);
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).containsExactlyInAnyOrder((Object[])new ContentRetriever[]{this.catArticlesRetriever, this.dogArticlesRetriever});
    }

    @Test
    void should_route_to_multiple_retrievers_with_custom_prompt_template() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Which source should I use to get answer for '{{query}}'? Options: {{options}}'");
        Query query = Query.from((String)"Which animal is the fluffiest?");
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("1, 2");
        LanguageModelQueryRouter router = new LanguageModelQueryRouter((ChatLanguageModel)model, retrieverToDescription, promptTemplate, LanguageModelQueryRouter.FallbackStrategy.FAIL);
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).containsExactlyInAnyOrder((Object[])new ContentRetriever[]{this.catArticlesRetriever, this.dogArticlesRetriever});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Which source should I use to get answer for 'Which animal is the fluffiest?'? Options: 1: articles about cats\n2: articles about dogs'");
    }

    @Test
    void should_not_route_by_default_when_LLM_returns_invalid_response() {
        Query query = Query.from((String)"Hey what's up?");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("Sorry, I don't know");
        Map<ContentRetriever, String> retrieverToDescription = Map.of(this.catArticlesRetriever, "articles about cats", this.dogArticlesRetriever, "articles about dogs");
        LanguageModelQueryRouter router = new LanguageModelQueryRouter((ChatLanguageModel)model, retrieverToDescription);
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).isEmpty();
    }

    @Test
    void should_not_route_by_default_when_LLM_call_fails() {
        Query query = Query.from((String)"Hey what's up?");
        ChatModelMock model = ChatModelMock.thatAlwaysThrowsException();
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        LanguageModelQueryRouter router = new LanguageModelQueryRouter((ChatLanguageModel)model, retrieverToDescription);
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).isEmpty();
    }

    @Test
    void should_route_to_all_retrievers_when_LLM_returns_invalid_response() {
        Query query = Query.from((String)"Hey what's up?");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("Sorry, I don't know");
        LanguageModelQueryRouter.FallbackStrategy fallbackStrategy = LanguageModelQueryRouter.FallbackStrategy.ROUTE_TO_ALL;
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        LanguageModelQueryRouter router = LanguageModelQueryRouter.builder().chatLanguageModel((ChatLanguageModel)model).retrieverToDescription(retrieverToDescription).fallbackStrategy(fallbackStrategy).build();
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).containsExactlyInAnyOrder((Object[])new ContentRetriever[]{this.catArticlesRetriever, this.dogArticlesRetriever});
    }

    @Test
    void should_route_to_all_retrievers_when_LLM_call_fails() {
        Query query = Query.from((String)"Hey what's up?");
        ChatModelMock model = ChatModelMock.thatAlwaysThrowsException();
        LanguageModelQueryRouter.FallbackStrategy fallbackStrategy = LanguageModelQueryRouter.FallbackStrategy.ROUTE_TO_ALL;
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        LanguageModelQueryRouter router = LanguageModelQueryRouter.builder().chatLanguageModel((ChatLanguageModel)model).retrieverToDescription(retrieverToDescription).fallbackStrategy(fallbackStrategy).build();
        Collection retrievers = router.route(query);
        Assertions.assertThat((Collection)retrievers).containsExactlyInAnyOrder((Object[])new ContentRetriever[]{this.catArticlesRetriever, this.dogArticlesRetriever});
    }

    @Test
    void should_fail_when_LLM_returns_invalid_response() {
        Query query = Query.from((String)"Hey what's up?");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("Sorry, I don't know");
        LanguageModelQueryRouter.FallbackStrategy fallbackStrategy = LanguageModelQueryRouter.FallbackStrategy.FAIL;
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        LanguageModelQueryRouter router = LanguageModelQueryRouter.builder().chatLanguageModel((ChatLanguageModel)model).retrieverToDescription(retrieverToDescription).fallbackStrategy(fallbackStrategy).build();
        Assertions.assertThatThrownBy(() -> LanguageModelQueryRouterTest.lambda$should_fail_when_LLM_returns_invalid_response$0((QueryRouter)router, query)).hasRootCauseExactlyInstanceOf(NumberFormatException.class);
    }

    @Test
    void should_fail_when_LLM_call_fails() {
        Query query = Query.from((String)"Hey what's up?");
        ChatModelMock model = ChatModelMock.thatAlwaysThrowsExceptionWithMessage("Something went wrong");
        LanguageModelQueryRouter.FallbackStrategy fallbackStrategy = LanguageModelQueryRouter.FallbackStrategy.FAIL;
        LinkedHashMap<ContentRetriever, String> retrieverToDescription = new LinkedHashMap<ContentRetriever, String>();
        retrieverToDescription.put(this.catArticlesRetriever, "articles about cats");
        retrieverToDescription.put(this.dogArticlesRetriever, "articles about dogs");
        LanguageModelQueryRouter router = LanguageModelQueryRouter.builder().chatLanguageModel((ChatLanguageModel)model).retrieverToDescription(retrieverToDescription).fallbackStrategy(fallbackStrategy).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LanguageModelQueryRouterTest.lambda$should_fail_when_LLM_call_fails$1((QueryRouter)router, query)).isExactlyInstanceOf(RuntimeException.class)).hasMessageContaining("Something went wrong");
    }

    private static /* synthetic */ void lambda$should_fail_when_LLM_call_fails$1(QueryRouter router, Query query) throws Throwable {
        router.route(query);
    }

    private static /* synthetic */ void lambda$should_fail_when_LLM_returns_invalid_response$0(QueryRouter router, Query query) throws Throwable {
        router.route(query);
    }
}

