/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.retriever;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.retriever.Retriever;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class RetrieverTest
implements WithAssertions {
    RetrieverTest() {
    }

    @Test
    void findRelevant() {
        TestRetriever retriever = new TestRetriever();
        this.assertThat(retriever.findRelevant("test")).containsOnly((Object[])new String[]{"abc"});
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> retriever.findRelevant("test", "test")).withMessage("Not implemented");
    }

    @Test
    void should_convert_to_content_retriever() {
        Retriever retriever = text -> Collections.singletonList(TextSegment.from((String)text));
        String query = "does not matter";
        ContentRetriever contentRetriever = retriever.toContentRetriever();
        this.assertThat(contentRetriever.retrieve(Query.from((String)query))).containsExactly((Object[])new Content[]{Content.from((String)query)});
    }

    public static class TestRetriever
    implements Retriever<String> {
        public List<String> findRelevant(String text) {
            return Collections.singletonList("abc");
        }
    }
}

