/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingStoreWithoutMetadataIT;
import dev.langchain4j.store.embedding.TestUtils;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

public abstract class EmbeddingStoreIT
extends EmbeddingStoreWithoutMetadataIT {
    protected static final UUID TEST_UUID = UUID.randomUUID();
    protected static final UUID TEST_UUID2 = UUID.randomUUID();

    @Test
    void should_add_embedding_with_segment_with_metadata() {
        Metadata metadata = this.createMetadata();
        TextSegment segment = TextSegment.from((String)"hello", (Metadata)metadata);
        Embedding embedding = (Embedding)this.embeddingModel().embed(segment.text()).content();
        String id = this.embeddingStore().add(embedding, (Object)segment);
        Assertions.assertThat((String)id).isNotBlank();
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        List relevant = this.embeddingStore().findRelevant(embedding, 1);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        }
        Assertions.assertThat((String)((TextSegment)match.embedded()).text()).isEqualTo(segment.text());
        Assertions.assertThat((String)((TextSegment)match.embedded()).metadata().getString("string_empty")).isEmpty();
        Assertions.assertThat((String)((TextSegment)match.embedded()).metadata().getString("string_space")).isEqualTo(" ");
        Assertions.assertThat((String)((TextSegment)match.embedded()).metadata().getString("string_abc")).isEqualTo("abc");
        Assertions.assertThat((Comparable)((TextSegment)match.embedded()).metadata().getUUID("uuid")).isEqualTo((Object)TEST_UUID);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_min")).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_minus_1")).isEqualTo(-1);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_0")).isEqualTo(0);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_1")).isEqualTo(1);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_max")).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_min")).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_minus_1")).isEqualTo(-1L);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_0")).isEqualTo(0L);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_1")).isEqualTo(1L);
        if (this.testLong1746714878034235396()) {
            Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_1746714878034235396")).isEqualTo(1746714878034235396L);
        }
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_max")).isEqualTo(Long.MAX_VALUE);
        if (this.testFloatExactly()) {
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_min")).isEqualTo(-3.4028235E38f);
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_minus_1")).isEqualTo(-1.0f);
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_0")).isEqualTo(Float.MIN_VALUE);
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_1")).isEqualTo(1.0f);
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_123")).isEqualTo(1.2345679f);
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_max")).isEqualTo(Float.MAX_VALUE);
        } else {
            double floatPercentage = this.floatPercentage();
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_min")).isCloseTo(-3.4028235E38f, Percentage.withPercentage((double)floatPercentage));
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_minus_1")).isCloseTo(-1.0f, Percentage.withPercentage((double)floatPercentage));
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_0")).isCloseTo(Float.MIN_VALUE, Percentage.withPercentage((double)floatPercentage));
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_1")).isCloseTo(1.0f, Percentage.withPercentage((double)floatPercentage));
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_123")).isCloseTo(1.2345679f, Percentage.withPercentage((double)floatPercentage));
            Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_max")).isCloseTo(Float.MAX_VALUE, Percentage.withPercentage((double)floatPercentage));
        }
        if (this.testDoubleExactly()) {
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_minus_1")).isEqualTo(-1.0);
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_0")).isEqualTo(Double.MIN_VALUE);
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_1")).isEqualTo(1.0);
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_123")).isEqualTo(1.23456789);
        } else {
            double doublePercentage = this.doublePercentage();
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_minus_1")).isCloseTo(-1.0, Percentage.withPercentage((double)doublePercentage));
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_0")).isCloseTo(Double.MIN_VALUE, Percentage.withPercentage((double)doublePercentage));
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_1")).isCloseTo(1.0, Percentage.withPercentage((double)doublePercentage));
            Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_123")).isCloseTo(1.23456789, Percentage.withPercentage((double)doublePercentage));
        }
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(1)).build()).matches()).isEqualTo((Object)relevant);
    }

    protected boolean testLong1746714878034235396() {
        return true;
    }

    protected boolean testFloatExactly() {
        return true;
    }

    protected boolean testDoubleExactly() {
        return true;
    }

    protected double floatPercentage() {
        return 0.01;
    }

    protected double doublePercentage() {
        return 0.01;
    }

    protected Metadata createMetadata() {
        Metadata metadata = new Metadata();
        metadata.put("string_empty", "");
        metadata.put("string_space", " ");
        metadata.put("string_abc", "abc");
        metadata.put("uuid", TEST_UUID);
        metadata.put("integer_min", Integer.MIN_VALUE);
        metadata.put("integer_minus_1", -1);
        metadata.put("integer_0", 0);
        metadata.put("integer_1", 1);
        metadata.put("integer_max", Integer.MAX_VALUE);
        metadata.put("long_min", Long.MIN_VALUE);
        metadata.put("long_minus_1", -1L);
        metadata.put("long_0", 0L);
        metadata.put("long_1", 1L);
        if (this.testLong1746714878034235396()) {
            metadata.put("long_1746714878034235396", 1746714878034235396L);
        }
        metadata.put("long_max", Long.MAX_VALUE);
        metadata.put("float_min", -3.4028235E38f);
        metadata.put("float_minus_1", -1.0f);
        metadata.put("float_0", Float.MIN_VALUE);
        metadata.put("float_1", 1.0f);
        metadata.put("float_123", 1.2345679f);
        metadata.put("float_max", Float.MAX_VALUE);
        metadata.put("double_minus_1", -1.0);
        metadata.put("double_0", Double.MIN_VALUE);
        metadata.put("double_1", 1.0);
        metadata.put("double_123", 1.23456789);
        return metadata;
    }
}

