/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import dev.langchain4j.store.embedding.TestUtils;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class EmbeddingStoreWithoutMetadataIT {
    protected abstract EmbeddingStore<TextSegment> embeddingStore();

    protected abstract EmbeddingModel embeddingModel();

    @BeforeEach
    void beforeEach() {
        this.ensureStoreIsReady();
        this.clearStore();
        this.ensureStoreIsEmpty();
    }

    protected void ensureStoreIsReady() {
    }

    protected void clearStore() {
    }

    protected void ensureStoreIsEmpty() {
        Assertions.assertThat(this.getAllEmbeddings()).isEmpty();
    }

    @Test
    void should_add_embedding() {
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        String id = this.embeddingStore().add(embedding);
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        List relevant = this.embeddingStore().findRelevant(embedding, 10);
        Assertions.assertThat((String)id).isNotBlank();
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        }
        Assertions.assertThat((Object)((TextSegment)match.embedded())).isNull();
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_embedding_with_id() {
        String id = Utils.randomUUID();
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        this.embeddingStore().add(id, embedding);
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        List relevant = this.embeddingStore().findRelevant(embedding, 10);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        }
        Assertions.assertThat((Object)((TextSegment)match.embedded())).isNull();
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_embedding_with_segment() {
        TextSegment segment = TextSegment.from((String)"hello");
        Embedding embedding = (Embedding)this.embeddingModel().embed(segment.text()).content();
        String id = this.embeddingStore().add(embedding, (Object)segment);
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        List relevant = this.embeddingStore().findRelevant(embedding, 10);
        Assertions.assertThat((String)id).isNotBlank();
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        }
        Assertions.assertThat((Object)((TextSegment)match.embedded())).isEqualTo((Object)segment);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_multiple_embeddings() {
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed("hello").content();
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed("hi").content();
        List ids = this.embeddingStore().addAll(Arrays.asList(firstEmbedding, secondEmbedding));
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(2));
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)ids).hasSize(2);
        Assertions.assertThat((String)((String)ids.get(0))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(1))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(0))).isNotEqualTo(ids.get(1));
        Assertions.assertThat((List)relevant).hasSize(2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo((String)ids.get(0));
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)firstMatch.embedding()).isEqualTo((Object)firstEmbedding);
        }
        Assertions.assertThat((Object)((TextSegment)firstMatch.embedded())).isNull();
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), this.percentage());
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo((String)ids.get(1));
        if (this.assertEmbedding()) {
            Assertions.assertThat((double)CosineSimilarity.between((Embedding)secondMatch.embedding(), (Embedding)secondEmbedding)).isCloseTo(1.0, Percentage.withPercentage((double)0.01));
        }
        Assertions.assertThat((Object)((TextSegment)secondMatch.embedded())).isNull();
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_multiple_embeddings_with_segments() {
        TextSegment firstSegment = TextSegment.from((String)"hello");
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed(firstSegment.text()).content();
        TextSegment secondSegment = TextSegment.from((String)"hi");
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed(secondSegment.text()).content();
        List ids = this.embeddingStore().addAll(Arrays.asList(firstEmbedding, secondEmbedding), Arrays.asList(firstSegment, secondSegment));
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(2));
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)ids).hasSize(2);
        Assertions.assertThat((String)((String)ids.get(0))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(1))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(0))).isNotEqualTo(ids.get(1));
        Assertions.assertThat((List)relevant).hasSize(2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo((String)ids.get(0));
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)firstMatch.embedding()).isEqualTo((Object)firstEmbedding);
        }
        Assertions.assertThat((Object)((TextSegment)firstMatch.embedded())).isEqualTo((Object)firstSegment);
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), this.percentage());
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo((String)ids.get(1));
        if (this.assertEmbedding()) {
            Assertions.assertThat((double)CosineSimilarity.between((Embedding)secondMatch.embedding(), (Embedding)secondEmbedding)).isCloseTo(1.0, Percentage.withPercentage((double)0.01));
        }
        Assertions.assertThat((Object)((TextSegment)secondMatch.embedded())).isEqualTo((Object)secondSegment);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_multiple_embeddings_with_ids_and_segments() {
        String id1 = Utils.randomUUID();
        String id2 = Utils.randomUUID();
        TextSegment firstSegment = TextSegment.from((String)"hello");
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed(firstSegment.text()).content();
        TextSegment secondSegment = TextSegment.from((String)"hi");
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed(secondSegment.text()).content();
        this.embeddingStore().addAll(Arrays.asList(id1, id2), Arrays.asList(firstEmbedding, secondEmbedding), Arrays.asList(firstSegment, secondSegment));
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(2));
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)relevant).hasSize(2);
        Assertions.assertThat((Object)((EmbeddingMatch)relevant.get(0))).isNotNull();
        Assertions.assertThat((Object)((EmbeddingMatch)relevant.get(1))).isNotNull();
        Assertions.assertThat((String)((EmbeddingMatch)relevant.get(0)).embeddingId()).isEqualTo(id1);
        Assertions.assertThat((String)((EmbeddingMatch)relevant.get(1)).embeddingId()).isEqualTo(id2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo(id1);
        if (this.assertEmbedding()) {
            Assertions.assertThat((Object)firstMatch.embedding()).isEqualTo((Object)firstEmbedding);
        }
        Assertions.assertThat((Object)((TextSegment)firstMatch.embedded())).isEqualTo((Object)firstSegment);
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), this.percentage());
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo(id2);
        if (this.assertEmbedding()) {
            Assertions.assertThat((double)CosineSimilarity.between((Embedding)secondMatch.embedding(), (Embedding)secondEmbedding)).isCloseTo(1.0, Percentage.withPercentage((double)0.01));
        }
        Assertions.assertThat((Object)((TextSegment)secondMatch.embedded())).isEqualTo((Object)secondSegment);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_find_with_min_score() {
        String firstId = Utils.randomUUID();
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed("hello").content();
        this.embeddingStore().add(firstId, firstEmbedding);
        String secondId = Utils.randomUUID();
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed("hi").content();
        this.embeddingStore().add(secondId, secondEmbedding);
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(2));
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)relevant).hasSize(2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, this.percentage());
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo(firstId);
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), this.percentage());
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo(secondId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
        List relevant2 = this.embeddingStore().findRelevant(firstEmbedding, 10, secondMatch.score() - 0.01);
        Assertions.assertThat((List)relevant2).hasSize(2);
        Assertions.assertThat((String)((EmbeddingMatch)relevant2.get(0)).embeddingId()).isEqualTo(firstId);
        Assertions.assertThat((String)((EmbeddingMatch)relevant2.get(1)).embeddingId()).isEqualTo(secondId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).minScore(Double.valueOf(secondMatch.score() - 0.01)).build()).matches()).isEqualTo((Object)relevant2);
        List relevant3 = this.embeddingStore().findRelevant(firstEmbedding, 10, secondMatch.score().doubleValue());
        Assertions.assertThat((List)relevant3).hasSize(2);
        Assertions.assertThat((String)((EmbeddingMatch)relevant3.get(0)).embeddingId()).isEqualTo(firstId);
        Assertions.assertThat((String)((EmbeddingMatch)relevant3.get(1)).embeddingId()).isEqualTo(secondId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).minScore(secondMatch.score()).build()).matches()).isEqualTo((Object)relevant3);
        List relevant4 = this.embeddingStore().findRelevant(firstEmbedding, 10, secondMatch.score() + 0.01);
        Assertions.assertThat((List)relevant4).hasSize(1);
        Assertions.assertThat((String)((EmbeddingMatch)relevant4.get(0)).embeddingId()).isEqualTo(firstId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).minScore(Double.valueOf(secondMatch.score() + 0.01)).build()).matches()).isEqualTo((Object)relevant4);
    }

    @Test
    void should_return_correct_score() {
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        String id = this.embeddingStore().add(embedding);
        Assertions.assertThat((String)id).isNotBlank();
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        Embedding referenceEmbedding = (Embedding)this.embeddingModel().embed("hi").content();
        List relevant = this.embeddingStore().findRelevant(referenceEmbedding, 1);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)embedding, (Embedding)referenceEmbedding)), this.percentage());
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(referenceEmbedding).maxResults(Integer.valueOf(1)).build()).matches()).isEqualTo((Object)relevant);
    }

    protected List<EmbeddingMatch<TextSegment>> getAllEmbeddings() {
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding((Embedding)this.embeddingModel().embed("test").content()).maxResults(Integer.valueOf(1000)).build();
        EmbeddingSearchResult searchResult = this.embeddingStore().search(embeddingSearchRequest);
        return searchResult.matches();
    }

    protected boolean assertEmbedding() {
        return true;
    }

    protected Percentage percentage() {
        return Percentage.withPercentage((double)1.0);
    }
}

