/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.logical;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.logical.And;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AndTest {
    @Mock
    private Filter mockFilterPasses;
    @Mock
    private Filter mockFilterFails;

    AndTest() {
    }

    @Test
    void bothFiltersPass() {
        Mockito.when((Object)this.mockFilterPasses.test(Mockito.any())).thenReturn((Object)true);
        And andFilter = new And(this.mockFilterPasses, this.mockFilterPasses);
        Assertions.assertThat((boolean)andFilter.test(new Object())).isTrue();
    }

    @Test
    void leftFilterFails() {
        Mockito.when((Object)this.mockFilterFails.test(Mockito.any())).thenReturn((Object)false);
        And andFilter = new And(this.mockFilterFails, this.mockFilterPasses);
        Assertions.assertThat((boolean)andFilter.test(new Object())).isFalse();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockFilterPasses});
    }

    @Test
    void rightFilterFails() {
        Mockito.when((Object)this.mockFilterPasses.test(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockFilterFails.test(Mockito.any())).thenReturn((Object)false);
        And andFilter = new And(this.mockFilterPasses, this.mockFilterFails);
        Assertions.assertThat((boolean)andFilter.test(new Object())).isFalse();
    }

    @Test
    void bothFiltersFail() {
        Mockito.when((Object)this.mockFilterFails.test(Mockito.any())).thenReturn((Object)false);
        And andFilter = new And(this.mockFilterFails, this.mockFilterFails);
        Assertions.assertThat((boolean)andFilter.test(new Object())).isFalse();
    }

    @Test
    void equalsAndHashCode() {
        And andFilter = new And(this.mockFilterPasses, this.mockFilterPasses);
        And sameAndFilter = new And(this.mockFilterPasses, this.mockFilterPasses);
        ((ObjectAssert)Assertions.assertThat((Object)andFilter).isEqualTo((Object)sameAndFilter)).hasSameHashCodeAs((Object)sameAndFilter);
    }

    @Test
    void checkToStringImplemented() {
        And andFilter = new And(this.mockFilterPasses, this.mockFilterPasses);
        Assertions.assertThat((Object)andFilter).hasToString("And(left=mockFilterPasses, right=mockFilterPasses)");
    }
}

