/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.logical;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.logical.Not;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class NotTest {
    @Mock
    private Filter filter;
    private Not subject;

    NotTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.subject = new Not(this.filter);
    }

    @Test
    void shouldReturnFalseWhenNotMetadata() {
        boolean result2 = this.subject.test(new Object());
        Assertions.assertThat((boolean)result2).isFalse();
    }

    @Test
    void shouldReturnFalseWhenFilterReturnsTrue() {
        Mockito.when((Object)this.filter.test(ArgumentMatchers.any())).thenReturn((Object)true);
        boolean result2 = this.subject.test((Object)new Metadata());
        Assertions.assertThat((boolean)result2).isFalse();
    }

    @Test
    void shouldReturnTrueWhenFilterReturnsFalse() {
        Mockito.when((Object)this.filter.test(ArgumentMatchers.any())).thenReturn((Object)false);
        boolean result2 = this.subject.test((Object)new Metadata());
        Assertions.assertThat((boolean)result2).isTrue();
    }

    @Test
    void shouldReturnCorrectExpression() {
        Filter result2 = this.subject.expression();
        Assertions.assertThat((Object)result2).isEqualTo((Object)this.filter);
    }

    @Test
    void shouldHaveCorrectToStringImplementation() {
        Assertions.assertThat((Object)this.subject).hasToString("Not(expression=" + String.valueOf(this.filter) + ")");
    }

    @Test
    void shouldReturnTrueForEqualsWithSameExpression() {
        Not anotherWithSameExp = new Not(this.filter);
        ((ObjectAssert)Assertions.assertThat((Object)this.subject).isEqualTo((Object)anotherWithSameExp)).hasSameHashCodeAs((Object)anotherWithSameExp);
    }

    @Test
    void shouldReturnFalseForEqualsWithDifferentExpression() {
        Not anotherWithDiffExp = new Not((Filter)Mockito.mock(Filter.class));
        Assertions.assertThat((Object)this.subject).isNotEqualTo((Object)anotherWithDiffExp);
    }

    @Test
    void shouldHaveConsistentHashCode() {
        int initialHashCode = this.subject.hashCode();
        Assertions.assertThat((int)this.subject.hashCode()).isEqualTo(initialHashCode);
    }
}

