/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchResults;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class WebSearchResultsTest {
    WebSearchResultsTest() {
    }

    @Test
    void should_build_webSearchResults() {
        WebSearchResults webSearchResults = WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)1L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"))));
        Assertions.assertThat((List)webSearchResults.results()).hasSize(1);
        Assertions.assertThat((URI)((WebSearchOrganicResult)webSearchResults.results().get(0)).url()).hasToString("https://google.com");
        Assertions.assertThat((Long)webSearchResults.searchInformation().totalResults()).isEqualTo(1L);
        Assertions.assertThat((Object)webSearchResults).hasToString("WebSearchResults{searchMetadata=null, searchInformation=WebSearchInformationResult{totalResults=1, pageNumber=null, metadata=null}, results=[WebSearchOrganicResult{title='title', url=https://google.com, snippet='null', content='null', metadata=null}]}");
    }

    @Test
    void equals_and_hash() {
        WebSearchResults wsr1 = WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)1L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"))));
        WebSearchResults wsr2 = WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)1L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"))));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)wsr1).isEqualTo((Object)wsr1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)wsr2)).hasSameHashCodeAs((Object)wsr2);
        Assertions.assertThat((Object)WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)1L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://docs.langchain4j.dev"))))).isNotEqualTo((Object)wsr1);
        Assertions.assertThat((Object)WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)2L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"))))).isNotEqualTo((Object)wsr1);
    }

    @Test
    void should_return_array_of_textSegments_with_snippet() {
        WebSearchResults webSearchResults = WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)1L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null)));
        Assertions.assertThat((List)webSearchResults.toTextSegments()).hasSize(1);
        Assertions.assertThat((String)((TextSegment)webSearchResults.toTextSegments().get(0)).text()).isEqualTo("title\nsnippet");
        Assertions.assertThat((Object)((TextSegment)webSearchResults.toTextSegments().get(0)).metadata()).isEqualTo((Object)Metadata.from((String)"url", (String)"https://google.com"));
    }

    @Test
    void should_return_array_of_documents_with_content() {
        WebSearchResults webSearchResults = WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)1L), Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), null, (String)"content")));
        Assertions.assertThat((List)webSearchResults.toDocuments()).hasSize(1);
        Assertions.assertThat((String)((Document)webSearchResults.toDocuments().get(0)).text()).isEqualTo("title\ncontent");
        Assertions.assertThat((Object)((Document)webSearchResults.toDocuments().get(0)).metadata()).isEqualTo((Object)Metadata.from((String)"url", (String)"https://google.com"));
    }

    @Test
    void should_throw_illegalArgumentException_without_searchInformation() {
        HashMap<String, String> searchMetadata = new HashMap<String, String>();
        searchMetadata.put("key", "value");
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new WebSearchResults(searchMetadata, null, Collections.singletonList(WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null))));
    }
}

