/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchTool;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class WebSearchToolIT {
    protected abstract WebSearchEngine searchEngine();

    protected abstract ChatLanguageModel chatLanguageModel();

    @Test
    void should_be_usable_tool_with_chatLanguageModel() {
        WebSearchTool webSearchTool = WebSearchTool.from((WebSearchEngine)this.searchEngine());
        List tools = ToolSpecifications.toolSpecificationsFrom((Object)webSearchTool);
        UserMessage userMessage = UserMessage.from((String)"What is LangChain4j project?");
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).toolSpecifications(tools).build();
        AiMessage aiMessage = this.chatLanguageModel().chat(chatRequest).aiMessage();
        Assertions.assertThat((boolean)aiMessage.hasToolExecutionRequests()).isTrue();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).anySatisfy(toolSpec -> {
            Assertions.assertThat((String)toolSpec.name()).containsIgnoringCase((CharSequence)"searchWeb");
            Assertions.assertThat((String)toolSpec.arguments()).isNotBlank();
        });
    }

    @Test
    void should_return_pretty_result_as_a_tool() {
        WebSearchTool webSearchTool = WebSearchTool.from((WebSearchEngine)this.searchEngine());
        String searchTerm = "What is LangChain4j project?";
        String strResult = webSearchTool.searchWeb(searchTerm);
        Assertions.assertThat((String)strResult).isNotBlank();
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)strResult).as("At least the string result should be contains 'java' and 'AI' ignoring case", new Object[0])).containsIgnoringCase((CharSequence)"Java")).containsIgnoringCase((CharSequence)"AI");
    }
}

