/*
 * Decompiled with CFR 0.152.
 */
package dev.linwood.api.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public abstract class FileConfig {
    private final String filePath;

    public FileConfig(String filePath) {
        this.filePath = filePath;
        try {
            Files.createDirectories(this.getParentDirectory(), new FileAttribute[0]);
            if (!Files.exists(this.getPath(), new LinkOption[0])) {
                Files.createFile(this.getPath(), new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract String getData();

    protected abstract void read(BufferedReader var1);

    public Path getParentDirectory() {
        return this.getPath().getParent();
    }

    @NotNull
    public Path getPath() {
        return Paths.get(this.filePath, new String[0]);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void save() {
        try {
            Files.createDirectories(this.getParentDirectory(), new FileAttribute[0]);
            if (!Files.exists(this.getPath(), new LinkOption[0])) {
                Files.createFile(this.getPath(), new FileAttribute[0]);
            }
            OutputStreamWriter bw = new OutputStreamWriter(Files.newOutputStream(this.getPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            bw.write(this.getData());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            BufferedReader br = Files.newBufferedReader(this.getPath(), StandardCharsets.UTF_8);
            this.read(br);
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

