/*
 * Decompiled with CFR 0.152.
 */
package dev.linwood.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.linwood.api.config.FileConfig;
import java.io.BufferedReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class JsonConfig
extends FileConfig {
    protected JsonObject jsonObject = new JsonObject();
    private Gson gson = new GsonBuilder().create();

    public JsonConfig(String filePath) {
        super(filePath);
    }

    public JsonConfig(@NotNull Gson gson, String filePath) {
        super(filePath);
        this.gson = gson;
        this.reload();
    }

    @Override
    protected String getData() {
        return this.gson.toJson((JsonElement)this.getJsonObject());
    }

    @Override
    protected void read(@NotNull BufferedReader reader) {
        this.setJsonObject((JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class));
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }
}

