/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.add;

import dev.logchange.core.application.changelog.repository.ChangelogEntryRepository;
import dev.logchange.core.application.changelog.service.add.AddChangelogEntryService;
import dev.logchange.core.application.file.repository.FileWriter;
import dev.logchange.core.domain.changelog.command.AddChangelogEntryUseCase;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogEntryRepository;
import dev.logchange.core.infrastructure.persistance.file.FileRepository;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import lombok.Generated;

public class AddEntryCommand {
    @Generated
    private static final Logger log = Logger.getLogger(AddEntryCommand.class.getName());
    private final String rootPath;
    private final String inputDir;
    private final String unreleasedVersionDir;

    public static AddEntryCommand of(String rootPath, String inputDir, String unreleasedVersionDir) {
        AddEntryCommand.checkIfCanAdd(rootPath, inputDir, unreleasedVersionDir);
        return new AddEntryCommand(rootPath, inputDir, unreleasedVersionDir);
    }

    public void execute(ChangelogEntry entry, String outputFile) {
        log.info("Adding new entry");
        String path = this.rootPath + "/" + this.inputDir + "/" + this.unreleasedVersionDir + "/" + outputFile;
        File entryFile = this.createFile(path);
        log.finer(entry.toString());
        FileChangelogEntryRepository repository = new FileChangelogEntryRepository((FileWriter)FileRepository.of((File)entryFile));
        AddChangelogEntryService addChangelogEntry = new AddChangelogEntryService((ChangelogEntryRepository)repository);
        AddChangelogEntryUseCase.AddChangelogEntryCommand command = AddChangelogEntryUseCase.AddChangelogEntryCommand.of((ChangelogEntry)entry);
        addChangelogEntry.handle(command);
        log.info("Entry saved");
    }

    private File createFile(String path) {
        try {
            File changelog = new File(path);
            if (changelog.createNewFile()) {
                log.info("Created: " + changelog.getName());
                return changelog;
            }
            String msg = "Entry with name: " + changelog.getName() + "  already exists!";
            log.warning(msg);
            throw new RuntimeException(msg);
        }
        catch (IOException e) {
            String msg = String.format("An error occurred while creating empty changelog entry file with path: %s - %s", path, e.getMessage());
            log.severe(msg);
            throw new RuntimeException(msg);
        }
    }

    private static void checkIfCanAdd(String rootPath, String inputDir, String unreleasedVersionDir) {
        String path = rootPath + "/" + inputDir + "/" + unreleasedVersionDir;
        File unreleasedDir = new File(path);
        if (!unreleasedDir.exists() || !unreleasedDir.isDirectory()) {
            String msg = "Cannot add new entry if " + path + " not exists nor is directory";
            log.severe(msg);
            throw new RuntimeException(msg);
        }
    }

    @Generated
    private AddEntryCommand(String rootPath, String inputDir, String unreleasedVersionDir) {
        this.rootPath = rootPath;
        this.inputDir = inputDir;
        this.unreleasedVersionDir = unreleasedVersionDir;
    }
}

