/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.add;

import dev.logchange.commands.add.AddEntryPrompter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class OutputFileNameProvider {
    private final boolean empty;
    private final AddEntryPrompter prompter;
    private final String commandLineOutputFileName;

    public String get() {
        if (StringUtils.isNotBlank((CharSequence)this.commandLineOutputFileName)) {
            return this.adjust(this.commandLineOutputFileName);
        }
        if (this.empty) {
            throw new IllegalArgumentException("When using -Dempty or -DbatchMode option, you have to also use -DfileName=0001-some-change.yml");
        }
        try {
            return this.getOutputFileName();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get file name", e);
        }
    }

    public String adjust(String commandLineOutputFileName) {
        return commandLineOutputFileName.replaceAll("\\.yml", "").replaceAll("\\.yaml", "").replaceAll("/", "_").replaceAll("\\.", "_").replaceAll(":", "_") + ".yml";
    }

    private String getOutputFileName() {
        String name;
        while (true) {
            if (StringUtils.isBlank((CharSequence)(name = this.prompter.prompt("What is the filename(e.g. 000231-adding-new-product)")))) {
                this.prompter.showMessage("Filename cannot be empty nor blank!!!");
                continue;
            }
            if (!StringUtils.isWhitespace((CharSequence)name)) break;
            this.prompter.showMessage("Filename cannot contain whitespace!!!");
        }
        name = name.replace(".yml", "").replace(".yaml", "");
        return name + ".yml";
    }

    @Generated
    public OutputFileNameProvider(boolean empty, AddEntryPrompter prompter, String commandLineOutputFileName) {
        this.empty = empty;
        this.prompter = prompter;
        this.commandLineOutputFileName = commandLineOutputFileName;
    }
}

