/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.aggregate;

import dev.logchange.core.application.changelog.repository.AggregatedVersionQuery;
import dev.logchange.core.application.changelog.repository.VersionSummaryRepository;
import dev.logchange.core.application.changelog.service.aggregate.AggregateProjectsVersionService;
import dev.logchange.core.application.config.ConfigFile;
import dev.logchange.core.application.file.Dir;
import dev.logchange.core.application.file.query.FileQuery;
import dev.logchange.core.application.file.query.TarGzQuery;
import dev.logchange.core.domain.changelog.command.AggregateProjectsVersionUseCase;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.domain.config.model.aggregate.Aggregates;
import dev.logchange.core.infrastructure.persistance.changelog.FileVersionSummaryRepository;
import dev.logchange.core.infrastructure.query.changelog.FileAggregatedVersionFinder;
import dev.logchange.core.infrastructure.query.file.FileReader;
import dev.logchange.core.infrastructure.query.file.TarGzExtractor;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import lombok.Generated;

public class AggregateVersionCommand {
    @Generated
    private static final Logger log = Logger.getLogger(AggregateVersionCommand.class.getName());
    private final String rootPath;
    private final String aggregateVersion;
    private final String inputDir;
    private final String configFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        log.info("Started aggregating " + this.aggregateVersion + " version");
        File changelogDirectory = Dir.find((String)(this.rootPath + "/" + this.inputDir));
        String configPath = this.rootPath + "/" + this.inputDir + "/" + this.configFile;
        Config config = AggregateVersionCommand.getConfig(configPath);
        AggregateProjectsVersionUseCase.AggregateChangelogsVersionsCommand command = AggregateProjectsVersionUseCase.AggregateChangelogsVersionsCommand.of((Aggregates)config.getAggregates(), (String)this.aggregateVersion);
        this.createVersionDir(changelogDirectory.getPath(), command.getVersion().getDirName());
        Path tmpDir = Dir.createTmp();
        TarGzExtractor tarGzQuery = new TarGzExtractor(tmpDir);
        FileVersionSummaryRepository vsr = new FileVersionSummaryRepository(changelogDirectory, config);
        FileAggregatedVersionFinder avr = new FileAggregatedVersionFinder(command.getVersion(), (FileQuery)new FileReader());
        AggregateProjectsVersionService aggregateChangelogsVersionsService = new AggregateProjectsVersionService((AggregatedVersionQuery)avr, (VersionSummaryRepository)vsr, (TarGzQuery)tarGzQuery);
        try {
            aggregateChangelogsVersionsService.handle(command);
        }
        finally {
            log.info("Deleting tmp directory");
            Dir.delete((Path)tmpDir);
        }
        log.info("Aggregating " + this.aggregateVersion + " version successful");
    }

    private static Config getConfig(String configPath) {
        return (Config)ConfigFile.find((String)configPath).orElseThrow(() -> {
            String msg = String.format("There is no config file: %s for this project, but it is required for this action!", configPath);
            log.severe(msg);
            return new RuntimeException(msg);
        });
    }

    public void createVersionDir(String inputDir, String versionDir) {
        Dir.of((Path)Paths.get(inputDir, versionDir)).create();
    }

    @Generated
    private AggregateVersionCommand(String rootPath, String aggregateVersion, String inputDir, String configFile) {
        this.rootPath = rootPath;
        this.aggregateVersion = aggregateVersion;
        this.inputDir = inputDir;
        this.configFile = configFile;
    }

    @Generated
    public static AggregateVersionCommand of(String rootPath, String aggregateVersion, String inputDir, String configFile) {
        return new AggregateVersionCommand(rootPath, aggregateVersion, inputDir, configFile);
    }
}

