/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.generate;

import dev.logchange.core.application.changelog.repository.ChangelogRepository;
import dev.logchange.core.application.changelog.repository.VersionSummaryRepository;
import dev.logchange.core.application.changelog.service.generate.GenerateChangelogService;
import dev.logchange.core.application.changelog.service.generate.GenerateChangelogXMLService;
import dev.logchange.core.application.config.ConfigFile;
import dev.logchange.core.application.file.Dir;
import dev.logchange.core.application.file.query.FileQuery;
import dev.logchange.core.application.file.repository.FileWriter;
import dev.logchange.core.application.file.repository.XmlFileWriter;
import dev.logchange.core.domain.changelog.command.GenerateChangelogUseCase;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogRepository;
import dev.logchange.core.infrastructure.persistance.changelog.FileVersionSummaryRepository;
import dev.logchange.core.infrastructure.persistance.file.FileRepository;
import dev.logchange.core.infrastructure.query.file.FileReader;
import java.io.File;
import java.util.logging.Logger;
import lombok.Generated;

public class GenerateProjectCommand {
    @Generated
    private static final Logger log = Logger.getLogger(GenerateProjectCommand.class.getName());
    private final String rootPath;
    private final String inputDir;
    private final String outputFile;
    private final String configFile;
    private String xmlOutputFile;

    public GenerateProjectCommand withXml(String xmlOutputFile) {
        return new GenerateProjectCommand(this.rootPath, this.inputDir, this.outputFile, this.configFile, xmlOutputFile);
    }

    public void execute(Boolean xml) {
        log.info("Started generating " + this.outputFile);
        File changelogDirectory = Dir.find((String)(this.rootPath + "/" + this.inputDir));
        String configPath = this.rootPath + "/" + this.inputDir + "/" + this.configFile;
        Config config = ConfigFile.find((String)configPath).orElseGet(() -> {
            log.info("There is no config file:  " + configPath + " for this project, using defaults");
            return Config.EMPTY;
        });
        FileRepository fr = FileRepository.of((File)new File(this.outputFile));
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, config, (FileQuery)new FileReader(), (FileWriter)fr, (XmlFileWriter)fr);
        FileVersionSummaryRepository versionSummaryRepository = new FileVersionSummaryRepository(changelogDirectory, config);
        GenerateChangelogService generateChangelog = new GenerateChangelogService((ChangelogRepository)repository, (VersionSummaryRepository)versionSummaryRepository);
        GenerateChangelogUseCase.GenerateChangelogCommand command = GenerateChangelogUseCase.GenerateChangelogCommand.of();
        generateChangelog.handle(command);
        log.info("Generating " + this.outputFile + " successful");
        if (xml.booleanValue()) {
            this.generateChangesXml(this.xmlOutputFile, changelogDirectory, config, command);
        }
    }

    private void generateChangesXml(String xmlOutputFile, File changelogDirectory, Config config, GenerateChangelogUseCase.GenerateChangelogCommand command) {
        log.info("Started generating XML changelog file");
        FileRepository fr = FileRepository.of((File)new File(xmlOutputFile));
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, config, (FileQuery)new FileReader(), (FileWriter)fr, (XmlFileWriter)fr);
        GenerateChangelogXMLService generateChangelogXml = new GenerateChangelogXMLService((ChangelogRepository)repository);
        generateChangelogXml.handle(command);
        log.info("Generating " + xmlOutputFile + " successful");
    }

    @Generated
    private GenerateProjectCommand(String rootPath, String inputDir, String outputFile, String configFile, String xmlOutputFile) {
        this.rootPath = rootPath;
        this.inputDir = inputDir;
        this.outputFile = outputFile;
        this.configFile = configFile;
        this.xmlOutputFile = xmlOutputFile;
    }

    @Generated
    private GenerateProjectCommand(String rootPath, String inputDir, String outputFile, String configFile) {
        this.rootPath = rootPath;
        this.inputDir = inputDir;
        this.outputFile = outputFile;
        this.configFile = configFile;
    }

    @Generated
    public static GenerateProjectCommand of(String rootPath, String inputDir, String outputFile, String configFile) {
        return new GenerateProjectCommand(rootPath, inputDir, outputFile, configFile);
    }
}

