/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.init;

import dev.logchange.core.application.config.ConfigFile;
import dev.logchange.core.application.file.Dir;
import dev.logchange.core.application.file.GitKeep;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.infrastructure.persistance.config.FileConfigRepository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import lombok.Generated;

public class InitProjectCommand {
    @Generated
    private static final Logger log = Logger.getLogger(InitProjectCommand.class.getName());
    private final String rootPath;
    private final String inputDir;
    private final String unreleasedVersionDir;
    private final String outputFile;

    public void execute() {
        log.info("Initializing project");
        this.checkIfRootExists(this.rootPath);
        InitProjectCommand.createEmptyChangelogFile(Paths.get(this.rootPath, this.outputFile));
        InitProjectCommand.createUnreleased(this.rootPath, this.inputDir, this.unreleasedVersionDir);
        this.createConfig(this.rootPath, this.inputDir);
        log.info("Project initialized");
    }

    private void checkIfRootExists(String rootPath) {
        if (!new File(rootPath).exists()) {
            String msg = String.format("Root path: %s must exists! Check if you are in right directory!", rootPath);
            log.severe(msg);
            throw new RuntimeException(msg);
        }
    }

    private void createConfig(String rootPath, String inputDir) {
        log.info("Creating config file");
        File config = ConfigFile.of((Path)Paths.get(rootPath, inputDir, "logchange-config.yml")).create();
        FileConfigRepository configRepository = new FileConfigRepository(config);
        configRepository.save(Config.EMPTY);
    }

    public static void createUnreleased(String rootPath, String inputDir, String unreleasedVersionDir) {
        log.info("Creating unreleased directory");
        Path inputDirPath = Paths.get(rootPath, inputDir);
        Dir.of((Path)inputDirPath).create();
        Path unreleasedVersionDirPath = Paths.get(rootPath, inputDir, unreleasedVersionDir);
        Dir.of((Path)unreleasedVersionDirPath).create();
        Path gitKeepPath = Paths.get(rootPath, inputDir, unreleasedVersionDir, ".gitkeep");
        GitKeep.of((Path)gitKeepPath).create();
    }

    private static void createEmptyChangelogFile(Path path) {
        try {
            File changelog = path.toFile();
            if (changelog.createNewFile()) {
                log.info("Created: " + changelog.getName());
            } else {
                log.warning(changelog.getName() + " already exists.");
            }
        }
        catch (IOException e) {
            String msg = String.format("An error occurred while creating empty changelog: %s", e.getMessage());
            log.severe(msg);
            throw new RuntimeException(msg);
        }
    }

    @Generated
    private InitProjectCommand(String rootPath, String inputDir, String unreleasedVersionDir, String outputFile) {
        this.rootPath = rootPath;
        this.inputDir = inputDir;
        this.unreleasedVersionDir = unreleasedVersionDir;
        this.outputFile = outputFile;
    }

    @Generated
    public static InitProjectCommand of(String rootPath, String inputDir, String unreleasedVersionDir, String outputFile) {
        return new InitProjectCommand(rootPath, inputDir, unreleasedVersionDir, outputFile);
    }
}

