/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.lint;

import dev.logchange.core.application.changelog.repository.ChangelogRepository;
import dev.logchange.core.application.changelog.repository.VersionSummaryRepository;
import dev.logchange.core.application.changelog.service.generate.GenerateChangelogService;
import dev.logchange.core.application.config.ConfigFile;
import dev.logchange.core.application.file.Dir;
import dev.logchange.core.application.file.query.FileQuery;
import dev.logchange.core.application.file.repository.FileWriter;
import dev.logchange.core.application.file.repository.XmlFileWriter;
import dev.logchange.core.domain.changelog.command.ValidateChangelogUseCase;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogRepository;
import dev.logchange.core.infrastructure.persistance.changelog.FileVersionSummaryRepository;
import dev.logchange.core.infrastructure.persistance.file.FileRepository;
import dev.logchange.core.infrastructure.query.file.FileReader;
import dev.logchange.utils.logger.LogchangeLogger;
import java.io.File;
import lombok.Generated;

public class LintProjectCommand {
    @Generated
    private static final LogchangeLogger log = LogchangeLogger.getLogger(LintProjectCommand.class);
    private final String rootPath;
    private final String inputDir;
    private final String outputFile;
    private final String configFile;

    public void validate() {
        log.info("Started validation of " + this.inputDir + " and " + this.configFile);
        File changelogDirectory = Dir.find((String)(this.rootPath + "/" + this.inputDir));
        String configPath = this.rootPath + "/" + this.inputDir + "/" + this.configFile;
        Config config = ConfigFile.find((String)configPath).orElseGet(() -> {
            log.info("There is no config file:  " + configPath + " for this project, using defaults");
            return Config.EMPTY;
        });
        FileRepository fr = FileRepository.of((File)new File(this.outputFile));
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, config, (FileQuery)new FileReader(), (FileWriter)fr, (XmlFileWriter)fr);
        FileVersionSummaryRepository versionSummaryRepository = new FileVersionSummaryRepository(changelogDirectory, config);
        GenerateChangelogService validateChangelog = new GenerateChangelogService((ChangelogRepository)repository, (VersionSummaryRepository)versionSummaryRepository);
        ValidateChangelogUseCase.ValidateChangelogCommand command = ValidateChangelogUseCase.ValidateChangelogCommand.of();
        validateChangelog.handle(command);
        log.info("Validation of " + this.inputDir + " and " + this.configFile + " successful");
    }

    @Generated
    private LintProjectCommand(String rootPath, String inputDir, String outputFile, String configFile) {
        this.rootPath = rootPath;
        this.inputDir = inputDir;
        this.outputFile = outputFile;
        this.configFile = configFile;
    }

    @Generated
    public static LintProjectCommand of(String rootPath, String inputDir, String outputFile, String configFile) {
        return new LintProjectCommand(rootPath, inputDir, outputFile, configFile);
    }
}

