/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.commands.release;

import dev.logchange.commands.generate.GenerateProjectCommand;
import dev.logchange.commands.init.InitProjectCommand;
import dev.logchange.commands.lint.LintProjectCommand;
import dev.logchange.core.format.release_date.ReleaseDate;
import dev.logchange.utils.logger.LogchangeLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ReleaseVersionCommand {
    @Generated
    private static final LogchangeLogger log = LogchangeLogger.getLogger(ReleaseVersionCommand.class);
    private static final String UNRELEASED_DIR_SEPARATOR = "-";
    private final String rootPath;
    private final String version;
    private final String unreleasedVersionDir;
    private final String inputDir;
    private final String outputFile;
    private final String configFile;
    private final boolean isGenerateChangesXml;
    private final String xmlOutputFile;

    public void execute() {
        log.info("Begin preparation from new changelog release: " + this.version);
        Path unreleasedDir = this.findUnreleasedDir();
        String newDirName = this.rootPath + "/" + this.inputDir + "/v" + this.version;
        LintProjectCommand.of(this.rootPath, this.inputDir, this.outputFile, this.configFile).validate();
        ReleaseDate.addToDir((Path)unreleasedDir);
        this.removeGitKeep(unreleasedDir);
        this.renameOrMergeDir(unreleasedDir, newDirName);
        GenerateProjectCommand.of(this.rootPath, this.inputDir, this.outputFile, this.configFile).withXml(this.xmlOutputFile).execute(this.isGenerateChangesXml);
        InitProjectCommand.createUnreleased(this.rootPath, this.inputDir, this.unreleasedVersionDir);
        log.info("New changelog release successful");
    }

    public static String getVersion(String version) {
        if (StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)"-SNAPSHOT")) {
            return version.substring(0, StringUtils.indexOfIgnoreCase((CharSequence)version, (CharSequence)"-SNAPSHOT"));
        }
        return version;
    }

    private void renameOrMergeDir(Path unreleasedDirPath, String newDirName) {
        File newDir;
        File unreleasedDir = unreleasedDirPath.toFile();
        if (unreleasedDir.renameTo(newDir = new File(newDirName))) {
            log.info("Renamed " + unreleasedDirPath + " to " + newDirName + " successfully");
        } else {
            log.info("Rename unsuccessful. Merging contents of " + unreleasedDirPath + " into " + newDirName);
            if (!newDir.exists()) {
                throw new RuntimeException("Target directory " + newDirName + " does not exist and renaming failed.");
            }
            this.moveDirectoryContents(unreleasedDir.toPath(), newDir.toPath());
            if (unreleasedDir.delete()) {
                log.info("Deleted empty folder: " + unreleasedDirPath);
            } else {
                log.warn("Failed to delete folder: " + unreleasedDirPath);
            }
        }
    }

    private void moveDirectoryContents(Path sourceDir, Path targetDir) {
        File[] files = sourceDir.toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                Path targetPath = targetDir.resolve(file.getName());
                try {
                    Files.move(file.toPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                log.info("Moved file: " + file.getName() + " to " + targetPath);
            }
        }
    }

    private void removeGitKeep(Path unreleasedDir) {
        File gitKeep = new File(unreleasedDir + "/" + ".gitkeep");
        if (gitKeep.delete()) {
            log.info("Deleted: " + gitKeep.getName());
        } else {
            log.warn(gitKeep.getName() + " cannot be deleted.");
        }
    }

    private Path findUnreleasedDir() {
        Path dirWithVersion = Paths.get(this.rootPath, this.inputDir, this.unreleasedVersionDir + UNRELEASED_DIR_SEPARATOR + this.version);
        if (this.isDir(dirWithVersion)) {
            return dirWithVersion;
        }
        Path standardUnreleasedDir = Paths.get(this.rootPath, this.inputDir, this.unreleasedVersionDir);
        log.info("Could not find " + dirWithVersion + " so checking if " + standardUnreleasedDir + " exists (ps. you can check out unreleased directories with specific version to allow simultaneous development of more than one version at same branch)");
        if (this.isDir(standardUnreleasedDir)) {
            return standardUnreleasedDir;
        }
        String msg = "THERE IS NO DIRECTORY TO RELEASE FROM! Check if your project contains: " + standardUnreleasedDir + " or " + dirWithVersion + " with YML files as changelog entries. Visit https://github.com/logchange/logchange for more details.";
        log.error(msg);
        throw new RuntimeException(msg);
    }

    private boolean isDir(Path path) {
        if (path.toFile().exists()) {
            if (path.toFile().isDirectory()) {
                log.info("Found directory: " + path);
                return true;
            }
            String msg = path + " is not a directory!";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        return false;
    }

    @Generated
    private ReleaseVersionCommand(String rootPath, String version, String unreleasedVersionDir, String inputDir, String outputFile, String configFile, boolean isGenerateChangesXml, String xmlOutputFile) {
        this.rootPath = rootPath;
        this.version = version;
        this.unreleasedVersionDir = unreleasedVersionDir;
        this.inputDir = inputDir;
        this.outputFile = outputFile;
        this.configFile = configFile;
        this.isGenerateChangesXml = isGenerateChangesXml;
        this.xmlOutputFile = xmlOutputFile;
    }

    @Generated
    public static ReleaseVersionCommand of(String rootPath, String version, String unreleasedVersionDir, String inputDir, String outputFile, String configFile, boolean isGenerateChangesXml, String xmlOutputFile) {
        return new ReleaseVersionCommand(rootPath, version, unreleasedVersionDir, inputDir, outputFile, configFile, isGenerateChangesXml, xmlOutputFile);
    }
}

