/*
 * Decompiled with CFR 0.152.
 */
package shadeio.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.UUID;
import shadeio.commons.io.TaggedIOException;
import shadeio.commons.io.input.ProxyReader;

public class TaggedReader
extends ProxyReader {
    private final Serializable tag = UUID.randomUUID();

    public TaggedReader(Reader proxy) {
        super(proxy);
    }

    @Override
    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this.tag);
    }

    public boolean isCauseOf(Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(Throwable throwable) throws IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }
}

