/*
 * Decompiled with CFR 0.152.
 */
package dev.mlnr.blh.jda;

import dev.mlnr.blh.core.api.IBLHUpdater;
import dev.mlnr.blh.core.internal.utils.Checks;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.sharding.ShardManager;

public class BLHJDAUpdater
implements IBLHUpdater {
    private JDA jda;
    private ShardManager shardManager;

    public BLHJDAUpdater(@Nonnull JDA jda) {
        Checks.notNull((Object)jda, (String)"The JDA object");
        this.jda = jda;
    }

    public BLHJDAUpdater(@Nonnull ShardManager shardManager) {
        Checks.notNull((Object)shardManager, (String)"The ShardManager object");
        Checks.check((shardManager.getShardById(0) == null ? 1 : 0) != 0, (String)"The shard 0 of the ShardManager may not be null");
        this.shardManager = shardManager;
    }

    public long getBotId() {
        long botId;
        if (this.jda == null) {
            JDA shard = this.shardManager.getShardById(0);
            Checks.check((shard == null ? 1 : 0) != 0, (String)"The shard 0 of the ShardManager may not be null");
            botId = shard.getSelfUser().getIdLong();
        } else {
            botId = this.jda.getSelfUser().getIdLong();
        }
        return botId;
    }

    public long getServerCount() {
        return this.jda == null ? this.shardManager.getGuildCache().size() : this.jda.getGuildCache().size();
    }
}

