/*
 * Decompiled with CFR 0.152.
 */
package conductor.orchestra;

import conductor.Conductor;
import conductor.ConductorException;
import conductor.Predicates;
import conductor.UiElement;
import conductor.orchestra.AssertCommand;
import conductor.orchestra.ConductorCommand;
import conductor.orchestra.ElementSelector;
import conductor.orchestra.InputTextCommand;
import conductor.orchestra.LaunchAppCommand;
import conductor.orchestra.TapOnElementCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u0012\u001a\b\u0002\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u0012 \b\u0002\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0014\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lconductor/orchestra/Orchestra;", "", "conductor", "Lconductor/Conductor;", "lookupTimeoutMs", "", "optionalLookupTimeoutMs", "onCommandStart", "Lkotlin/Function2;", "", "Lconductor/orchestra/ConductorCommand;", "", "onCommandComplete", "onCommandFailed", "Lkotlin/Function3;", "", "(Lconductor/Conductor;JJLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;)V", "assertCommand", "command", "Lconductor/orchestra/AssertCommand;", "assertVisible", "selector", "Lconductor/orchestra/ElementSelector;", "executeCommand", "executeCommands", "commands", "", "findElement", "Lconductor/UiElement;", "inputTextCommand", "Lconductor/orchestra/InputTextCommand;", "launchAppCommand", "it", "Lconductor/orchestra/LaunchAppCommand;", "tapOnElement", "Lconductor/orchestra/TapOnElementCommand;", "retryIfNoChange", "", "conductor-orchestra"})
public final class Orchestra {
    @NotNull
    private final Conductor conductor;
    private final long lookupTimeoutMs;
    private final long optionalLookupTimeoutMs;
    @NotNull
    private final Function2<Integer, ConductorCommand, Unit> onCommandStart;
    @NotNull
    private final Function2<Integer, ConductorCommand, Unit> onCommandComplete;
    @NotNull
    private final Function3<Integer, ConductorCommand, Throwable, Unit> onCommandFailed;

    public Orchestra(@NotNull Conductor conductor, long lookupTimeoutMs, long optionalLookupTimeoutMs, @NotNull Function2<? super Integer, ? super ConductorCommand, Unit> onCommandStart, @NotNull Function2<? super Integer, ? super ConductorCommand, Unit> onCommandComplete, @NotNull Function3<? super Integer, ? super ConductorCommand, ? super Throwable, Unit> onCommandFailed) {
        Intrinsics.checkNotNullParameter((Object)conductor, (String)"conductor");
        Intrinsics.checkNotNullParameter(onCommandStart, (String)"onCommandStart");
        Intrinsics.checkNotNullParameter(onCommandComplete, (String)"onCommandComplete");
        Intrinsics.checkNotNullParameter(onCommandFailed, (String)"onCommandFailed");
        this.conductor = conductor;
        this.lookupTimeoutMs = lookupTimeoutMs;
        this.optionalLookupTimeoutMs = optionalLookupTimeoutMs;
        this.onCommandStart = onCommandStart;
        this.onCommandComplete = onCommandComplete;
        this.onCommandFailed = onCommandFailed;
    }

    public /* synthetic */ Orchestra(Conductor conductor, long l, long l2, Function2 function2, Function2 function22, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 10000L;
        }
        if ((n & 4) != 0) {
            l2 = 3000L;
        }
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = 2.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function3 = 3.INSTANCE;
        }
        this(conductor, l, l2, (Function2<? super Integer, ? super ConductorCommand, Unit>)function2, (Function2<? super Integer, ? super ConductorCommand, Unit>)function22, (Function3<? super Integer, ? super ConductorCommand, ? super Throwable, Unit>)function3);
    }

    /*
     * WARNING - void declaration
     */
    public final void executeCommands(@NotNull List<ConductorCommand> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Iterable $this$forEachIndexed$iv = commands;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void command;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ConductorCommand conductorCommand = (ConductorCommand)item$iv;
            int index = n;
            boolean bl = false;
            this.onCommandStart.invoke((Object)index, (Object)command);
            try {
                this.executeCommand((ConductorCommand)command);
                this.onCommandComplete.invoke((Object)index, (Object)command);
            }
            catch (Throwable e) {
                this.onCommandFailed.invoke((Object)index, (Object)command, (Object)e);
                return;
            }
        }
    }

    private final void executeCommand(ConductorCommand command) {
        if (command.getTapOnElement() != null) {
            TapOnElementCommand tapOnElementCommand = command.getTapOnElement();
            if (tapOnElementCommand != null) {
                TapOnElementCommand it = tapOnElementCommand;
                boolean bl = false;
                Boolean bl2 = it.getRetryIfNoChange();
                this.tapOnElement(it, bl2 == null ? true : bl2);
            }
        } else if (command.getBackPressCommand() != null) {
            this.conductor.backPress();
        } else if (command.getScrollCommand() != null) {
            this.conductor.scrollVertical();
        } else if (command.getAssertCommand() != null) {
            AssertCommand assertCommand = command.getAssertCommand();
            if (assertCommand != null) {
                AssertCommand it = assertCommand;
                boolean bl = false;
                this.assertCommand(it);
            }
        } else if (command.getInputTextCommand() != null) {
            InputTextCommand inputTextCommand = command.getInputTextCommand();
            if (inputTextCommand != null) {
                InputTextCommand it = inputTextCommand;
                boolean bl = false;
                this.inputTextCommand(it);
            }
        } else if (command.getLaunchAppCommand() != null) {
            LaunchAppCommand launchAppCommand = command.getLaunchAppCommand();
            if (launchAppCommand != null) {
                LaunchAppCommand it = launchAppCommand;
                boolean bl = false;
                this.launchAppCommand(it);
            }
        }
    }

    private final void launchAppCommand(LaunchAppCommand it) {
        try {
            this.conductor.launchApp(it.getAppId());
        }
        catch (Exception e) {
            throw new ConductorException.UnableToLaunchApp("Unable to launch app " + it.getAppId() + ": " + e.getMessage());
        }
    }

    private final void inputTextCommand(InputTextCommand command) {
        this.conductor.inputText(command.getText());
    }

    private final void assertCommand(AssertCommand command) {
        ElementSelector elementSelector = command.getVisible();
        if (elementSelector != null) {
            ElementSelector it = elementSelector;
            boolean bl = false;
            this.assertVisible(it);
        }
    }

    private final void assertVisible(ElementSelector selector) {
        this.findElement(selector);
    }

    private final void tapOnElement(TapOnElementCommand command, boolean retryIfNoChange) {
        block2: {
            try {
                UiElement element = this.findElement(command.getSelector());
                this.conductor.tap(element, retryIfNoChange);
            }
            catch (ConductorException.ElementNotFound e) {
                if (command.getSelector().getOptional()) break block2;
                throw e;
            }
        }
    }

    private final UiElement findElement(ElementSelector selector) {
        String it;
        long timeout = selector.getOptional() ? this.optionalLookupTimeoutMs : this.lookupTimeoutMs;
        List predicates = new ArrayList();
        List descriptions = new ArrayList();
        String string = selector.getTextRegex();
        if (string != null) {
            it = string;
            boolean bl = false;
            ((Collection)descriptions).add(Intrinsics.stringPlus((String)"Text matching regex: ", (Object)it));
            ((Collection)predicates).add(Predicates.INSTANCE.textMatches(new Regex(it, RegexOption.IGNORE_CASE)));
        }
        string = selector.getIdRegex();
        if (string != null) {
            it = string;
            boolean bl = false;
            ((Collection)descriptions).add(Intrinsics.stringPlus((String)"Id matching regex: ", (Object)it));
            ((Collection)predicates).add(Predicates.INSTANCE.idMatches(new Regex(it, RegexOption.IGNORE_CASE)));
        }
        string = selector.getSize();
        if (string != null) {
            it = string;
            boolean bl = false;
            ((Collection)descriptions).add(Intrinsics.stringPlus((String)"Size: ", (Object)it));
            ((Collection)predicates).add(Predicates.INSTANCE.sizeMatches(it.getWidth(), it.getHeight(), it.getTolerance()));
        }
        string = this.conductor.findElementWithTimeout(timeout, Predicates.INSTANCE.allOf(predicates));
        if (string == null) {
            throw new ConductorException.ElementNotFound(Intrinsics.stringPlus((String)"Element not found: ", (Object)CollectionsKt.joinToString$default((Iterable)descriptions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
        }
        return string;
    }
}

