/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import util.CommandLineUtils;
import util.XCRunnerCLIUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0018\u001a\u00020\u0004J\u001d\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\b2\b\b\u0002\u0010#\u001a\u00020\u0016J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0%2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\bJ\u0016\u0010(\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lutil/XCRunnerCLIUtils;", "", "()V", "APP_AUTHOR", "", "APP_NAME", "LOG_DIR_DATE_FORMAT", "MAX_COUNT_XCTEST_LOGS", "", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "dateFormatter$delegate", "Lkotlin/Lazy;", "logDirectory", "Ljava/io/File;", "getLogDirectory", "()Ljava/io/File;", "logDirectory$delegate", "isAppAlive", "", "bundleId", "deviceId", "listApps", "", "pidForApp", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "resetProxy", "", "runXcTestWithoutBuild", "Ljava/lang/Process;", "xcTestRunFilePath", "port", "enableXCTestOutputFileLogging", "runningApps", "", "setProxy", "host", "uninstall", "maestro-ios-driver"})
@SourceDebugExtension(value={"SMAP\nXCRunnerCLIUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XCRunnerCLIUtils.kt\nutil/XCRunnerCLIUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,149:1\n1549#2:150\n1620#2,3:151\n766#2:154\n857#2,2:155\n1179#2,2:157\n1253#2,4:159\n1238#2,4:165\n468#3:163\n414#3:164\n*S KotlinDebug\n*F\n+ 1 XCRunnerCLIUtils.kt\nutil/XCRunnerCLIUtils\n*L\n103#1:150\n103#1:151,3\n104#1:154\n104#1:155,2\n105#1:157,2\n105#1:159,4\n106#1:165,4\n106#1:163\n106#1:164\n*E\n"})
public final class XCRunnerCLIUtils {
    @NotNull
    public static final XCRunnerCLIUtils INSTANCE = new XCRunnerCLIUtils();
    @NotNull
    private static final String APP_NAME = "maestro";
    @NotNull
    private static final String APP_AUTHOR = "mobile_dev";
    @NotNull
    private static final String LOG_DIR_DATE_FORMAT = "yyyy-MM-dd_HHmmss";
    private static final int MAX_COUNT_XCTEST_LOGS = 5;
    @NotNull
    private static final Lazy dateFormatter$delegate = LazyKt.lazy((Function0)dateFormatter.2.INSTANCE);
    @NotNull
    private static final Lazy logDirectory$delegate = LazyKt.lazy((Function0)logDirectory.2.INSTANCE);

    private XCRunnerCLIUtils() {
    }

    private final DateTimeFormatter getDateFormatter() {
        Lazy lazy = dateFormatter$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private final File getLogDirectory() {
        Lazy lazy = logDirectory$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final Set<String> listApps(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        String[] stringArray = new String[]{"bash", "-c", "xcrun simctl listapps " + deviceId + " | plutil -convert json - -o -"};
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        String json = new String(byArray, Charsets.UTF_8);
        if (((CharSequence)json).length() == 0) {
            return SetsKt.emptySet();
        }
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
        Object object = mapper.readValue(json, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map appsMap = (Map)object;
        return SetsKt.plus(appsMap.keySet(), (Iterable)this.runningApps(deviceId).keySet());
    }

    public final void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String[] stringArray = new String[]{"networksetup", "-setwebproxy", "Wi-Fi", host, String.valueOf(port)};
        new ProcessBuilder(stringArray).redirectErrorStream(true).start().waitFor();
        stringArray = new String[]{"networksetup", "-setsecurewebproxy", "Wi-Fi", host, String.valueOf(port)};
        new ProcessBuilder(stringArray).redirectErrorStream(true).start().waitFor();
    }

    public final void resetProxy() {
        String[] stringArray = new String[]{"networksetup", "-setwebproxystate", "Wi-Fi", "off"};
        new ProcessBuilder(stringArray).redirectErrorStream(true).start().waitFor();
        stringArray = new String[]{"networksetup", "-setsecurewebproxystate", "Wi-Fi", "off"};
        new ProcessBuilder(stringArray).redirectErrorStream(true).start().waitFor();
    }

    public final void uninstall(@NotNull String bundleId, @NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Object[] objectArray = new String[]{"xcrun", "simctl", "uninstall", deviceId, bundleId};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Integer> runningApps(String deviceId) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        void $this$associateTo$iv$iv;
        Map $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String[] stringArray = new String[]{"xcrun", "simctl", "spawn", deviceId, "launchctl", "list"};
        Process process = new ProcessBuilder(stringArray).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        Object object3 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object3, charset);
        int n = 8192;
        List processOutput = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        if (!process.waitFor(3000L, TimeUnit.MILLISECONDS)) {
            return MapsKt.emptyMap();
        }
        object3 = SequencesKt.toList((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)processOutput), (int)1));
        boolean $i$f$map = false;
        reader = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            String string = (String)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = (CharSequence)line;
            Regex regex = new Regex("\\s+");
            int n2 = 0;
            object2.add(regex.split((CharSequence)object, n2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List parts = (List)element$iv$iv;
            boolean bl = false;
            if (!(((Collection)parts).size() <= 3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            List parts = (List)element$iv$iv;
            boolean bl2 = false;
            object = TuplesKt.to(parts.get(2), (Object)StringsKt.toIntOrNull((String)((String)parts.get(0))));
            bl.put(object.getFirst(), object.getSecond());
        }
        $this$associate$iv = destination$iv$iv2;
        boolean $i$f$mapKeys = false;
        void capacity$iv22 = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            String key = (String)object.getKey();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            String string = StringsKt.replace$default((String)StringsKt.substringBefore$default((String)key, (String)"[", null, (int)2, null), (String)"UIKitApplication:", (String)"", (boolean)false, (int)4, null);
            Object object4 = object2;
            boolean bl3 = false;
            object = it$iv$iv.getValue();
            object4.put(string, object);
        }
        return destination$iv$iv;
    }

    public final boolean isAppAlive(@NotNull String bundleId, @NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        return this.runningApps(deviceId).containsKey(bundleId);
    }

    @Nullable
    public final Integer pidForApp(@NotNull String bundleId, @NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        return this.runningApps(deviceId).get(bundleId);
    }

    @NotNull
    public final Process runXcTestWithoutBuild(@NotNull String deviceId, @NotNull String xcTestRunFilePath, int port, boolean enableXCTestOutputFileLogging) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)xcTestRunFilePath, (String)"xcTestRunFilePath");
        String date = this.getDateFormatter().format(LocalDateTime.now());
        File outputFile = enableXCTestOutputFileLogging ? new File(this.getLogDirectory(), "xctest_runner_" + date + ".log") : null;
        Path logOutputDir = Files.createTempDirectory("maestro_xctestrunner_xcodebuild_output", new FileAttribute[0]);
        Object[] objectArray = new String[8];
        objectArray[0] = "xcodebuild";
        objectArray[1] = "test-without-building";
        objectArray[2] = "-xctestrun";
        objectArray[3] = xcTestRunFilePath;
        objectArray[4] = "-destination";
        objectArray[5] = "id=" + deviceId;
        objectArray[6] = "-derivedDataPath";
        Intrinsics.checkNotNullExpressionValue((Object)logOutputDir, (String)"logOutputDir");
        objectArray[7] = ((Object)logOutputDir.toAbsolutePath()).toString();
        return CommandLineUtils.INSTANCE.runCommand(CollectionsKt.listOf((Object[])objectArray), false, outputFile, MapsKt.mapOf((Pair)TuplesKt.to((Object)"TEST_RUNNER_PORT", (Object)String.valueOf(port))));
    }

    public static /* synthetic */ Process runXcTestWithoutBuild$default(XCRunnerCLIUtils xCRunnerCLIUtils, String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return xCRunnerCLIUtils.runXcTestWithoutBuild(string, string2, n, bl);
    }
}

