/*
 * Decompiled with CFR 0.152.
 */
package xcuitest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import hierarchy.ViewHierarchy;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import maestro.utils.HttpClient;
import maestro.utils.network.Error;
import maestro.utils.network.XCUITestServerError;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xcuitest.XCTestClient;
import xcuitest.api.DeviceInfo;
import xcuitest.api.EraseTextRequest;
import xcuitest.api.GetRunningAppIdResponse;
import xcuitest.api.GetRunningAppRequest;
import xcuitest.api.InputTextRequest;
import xcuitest.api.IsScreenStaticResponse;
import xcuitest.api.KeyboardInfoRequest;
import xcuitest.api.KeyboardInfoResponse;
import xcuitest.api.PressButtonRequest;
import xcuitest.api.PressKeyRequest;
import xcuitest.api.SetPermissionsRequest;
import xcuitest.api.SwipeRequest;
import xcuitest.api.TouchRequest;
import xcuitest.api.ViewHierarchyRequest;
import xcuitest.installer.XCTestInstaller;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001MB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0001H\u0002J\u0010\u0010\u001d\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0001H\u0002J \u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001cH\u0002J\u001c\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020)J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u000e\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001cJ\u000e\u0010/\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001cJ\u0018\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001cH\u0002J\u0006\u00104\u001a\u00020\u0012J\u0014\u00105\u001a\u0002062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u000e\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u000bJ\u001a\u00109\u001a\u00020\u00122\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0;J6\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020?J<\u0010D\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020?J'\u0010E\u001a\u00020\u00122\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020G2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010?\u00a2\u0006\u0002\u0010IJ\u001c\u0010J\u001a\u00020K2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010L\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lxcuitest/XCTestDriverClient;", "", "installer", "Lxcuitest/installer/XCTestInstaller;", "client", "Lxcuitest/XCTestClient;", "(Lxcuitest/installer/XCTestInstaller;Lxcuitest/XCTestClient;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lxcuitest/installer/XCTestInstaller;Lokhttp3/OkHttpClient;)V", "isShuttingDown", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "close", "", "deviceInfo", "Lxcuitest/api/DeviceInfo;", "httpUrl", "Lokhttp3/HttpUrl;", "eraseText", "charactersToErase", "", "appIds", "", "", "executeJsonRequest", "pathSegment", "body", "", "handleExceptions", "code", "pathString", "responseBodyAsString", "inputText", "text", "isChannelAlive", "isScreenStatic", "Lxcuitest/api/IsScreenStaticResponse;", "keyboardInfo", "Lxcuitest/api/KeyboardInfoResponse;", "installedApps", "pressButton", "name", "pressKey", "processResponse", "response", "Lokhttp3/Response;", "url", "restartXCTestRunner", "runningAppId", "Lxcuitest/api/GetRunningAppIdResponse;", "screenshot", "compressed", "setPermissions", "permissions", "", "swipe", "appId", "startX", "", "startY", "endX", "endY", "duration", "swipeV2", "tap", "x", "", "y", "(FFLjava/lang/Double;)V", "viewHierarchy", "Lhierarchy/ViewHierarchy;", "excludeKeyboardElements", "XCTestDriverUnreachable", "maestro-ios-driver"})
@SourceDebugExtension(value={"SMAP\nXCTestDriverClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XCTestDriverClient.kt\nxcuitest/XCTestDriverClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class XCTestDriverClient {
    @NotNull
    private final XCTestInstaller installer;
    @NotNull
    private final OkHttpClient okHttpClient;
    private final Logger logger;
    private XCTestClient client;
    private boolean isShuttingDown;
    @NotNull
    private final ObjectMapper mapper;

    public XCTestDriverClient(@NotNull XCTestInstaller installer, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        this.installer = installer;
        this.okHttpClient = okHttpClient;
        this.logger = LoggerFactory.getLogger(XCTestDriverClient.class);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> XCTestDriverClient._init_$lambda$0(this)));
        this.mapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
    }

    public /* synthetic */ XCTestDriverClient(XCTestInstaller xCTestInstaller, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            HttpClient httpClient = HttpClient.INSTANCE;
            long l = DurationKt.toDuration((int)200, (DurationUnit)DurationUnit.SECONDS);
            long l2 = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
            okHttpClient = HttpClient.build-OPOXi9g$default((HttpClient)httpClient, (String)"XCTestDriverClient", (long)l2, (long)l, (long)0L, null, null, null, null, (int)248, null);
        }
        this(xCTestInstaller, okHttpClient);
    }

    public XCTestDriverClient(@NotNull XCTestInstaller installer, @NotNull XCTestClient client) {
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this(installer, null, 2, null);
        this.client = client;
    }

    public final void restartXCTestRunner() {
        this.logger.trace("Restarting XCTest Runner (uninstalling, installing and starting)");
        this.installer.uninstall();
        this.logger.trace("XCTest Runner uninstalled, will install and start it");
        XCTestClient xCTestClient = this.installer.start();
        if (xCTestClient == null) {
            throw new XCTestDriverUnreachable("Failed to start XCTest Driver");
        }
        this.client = xCTestClient;
    }

    @NotNull
    public final ViewHierarchy viewHierarchy(@NotNull Set<String> installedApps, boolean excludeKeyboardElements) {
        Intrinsics.checkNotNullParameter(installedApps, (String)"installedApps");
        String responseString = this.executeJsonRequest("viewHierarchy", (Object)new ViewHierarchyRequest(installedApps, excludeKeyboardElements));
        Object object = this.mapper.readValue(responseString, ViewHierarchy.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(respons\u2026iewHierarchy::class.java)");
        return (ViewHierarchy)object;
    }

    @NotNull
    public final byte[] screenshot(boolean compressed) {
        XCTestClient xCTestClient = this.client;
        if (xCTestClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            xCTestClient = null;
        }
        HttpUrl url2 = xCTestClient.xctestAPIBuilder("screenshot").addQueryParameter("compressed", String.valueOf(compressed)).build();
        return this.executeJsonRequest(url2);
    }

    @NotNull
    public final KeyboardInfoResponse keyboardInfo(@NotNull Set<String> installedApps) {
        Intrinsics.checkNotNullParameter(installedApps, (String)"installedApps");
        String response = this.executeJsonRequest("keyboard", (Object)new KeyboardInfoRequest(installedApps));
        Object object = this.mapper.readValue(response, KeyboardInfoResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(respons\u2026InfoResponse::class.java)");
        return (KeyboardInfoResponse)object;
    }

    @NotNull
    public final IsScreenStaticResponse isScreenStatic() {
        String responseString = this.executeJsonRequest("isScreenStatic");
        Object object = this.mapper.readValue(responseString, IsScreenStaticResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(respons\u2026aticResponse::class.java)");
        return (IsScreenStaticResponse)object;
    }

    @NotNull
    public final GetRunningAppIdResponse runningAppId(@NotNull Set<String> appIds) {
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        String response = this.executeJsonRequest("runningApp", (Object)new GetRunningAppRequest(appIds));
        Object object = this.mapper.readValue(response, GetRunningAppIdResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(respons\u2026ppIdResponse::class.java)");
        return (GetRunningAppIdResponse)object;
    }

    public final void swipe(@NotNull String appId, double startX, double startY, double endX, double endY, double duration) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.executeJsonRequest("swipe", (Object)new SwipeRequest(appId, startX, startY, endX, endY, duration, null, 64, null));
    }

    public final void swipeV2(@NotNull Set<String> installedApps, double startX, double startY, double endX, double endY, double duration) {
        Intrinsics.checkNotNullParameter(installedApps, (String)"installedApps");
        this.executeJsonRequest("swipeV2", (Object)new SwipeRequest(null, startX, startY, endX, endY, duration, installedApps, 1, null));
    }

    public final void inputText(@NotNull String text, @NotNull Set<String> appIds) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        this.executeJsonRequest("inputText", (Object)new InputTextRequest(text, appIds));
    }

    public final void tap(float x, float y, @Nullable Double duration) {
        this.executeJsonRequest("touch", (Object)new TouchRequest(x, y, duration));
    }

    public static /* synthetic */ void tap$default(XCTestDriverClient xCTestDriverClient, float f, float f2, Double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = null;
        }
        xCTestDriverClient.tap(f, f2, d);
    }

    public final void pressKey(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.executeJsonRequest("pressKey", (Object)new PressKeyRequest(name));
    }

    public final void pressButton(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.executeJsonRequest("pressButton", (Object)new PressButtonRequest(name));
    }

    public final void eraseText(int charactersToErase, @NotNull Set<String> appIds) {
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        this.executeJsonRequest("eraseText", (Object)new EraseTextRequest(charactersToErase, appIds));
    }

    @NotNull
    public final DeviceInfo deviceInfo(@NotNull HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"httpUrl");
        String response = this.executeJsonRequest(httpUrl, (Object)Unit.INSTANCE);
        Object object = this.mapper.readValue(response, DeviceInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(response, DeviceInfo::class.java)");
        return (DeviceInfo)object;
    }

    public static /* synthetic */ DeviceInfo deviceInfo$default(XCTestDriverClient xCTestDriverClient, HttpUrl httpUrl, int n, Object object) {
        if ((n & 1) != 0) {
            XCTestClient xCTestClient = xCTestDriverClient.client;
            if (xCTestClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                xCTestClient = null;
            }
            httpUrl = xCTestClient.xctestAPIBuilder("deviceInfo").build();
        }
        return xCTestDriverClient.deviceInfo(httpUrl);
    }

    public final boolean isChannelAlive() {
        return this.installer.isChannelAlive();
    }

    public final void close() {
        this.installer.close();
    }

    public final void setPermissions(@NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.executeJsonRequest("setPermissions", (Object)new SetPermissionsRequest(permissions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String executeJsonRequest(HttpUrl httpUrl, Object body) {
        String string;
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        String string2 = this.mapper.writeValueAsString(body);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mapper.writeValueAsString(body)");
        RequestBody bodyData = RequestBody.Companion.create(string2, mediaType);
        Request.Builder requestBuilder = new Request.Builder().addHeader("Content-Type", "application/json").url(httpUrl).post(bodyData);
        Closeable closeable = (Closeable)this.okHttpClient.newCall(requestBuilder.build()).execute();
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            string = this.processResponse(it, httpUrl.toString());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] executeJsonRequest(HttpUrl httpUrl) {
        Object object;
        Request request2 = new Request.Builder().get().url(httpUrl).build();
        Closeable closeable = (Closeable)this.okHttpClient.newCall(request2).execute();
        Throwable throwable = null;
        try {
            Object bytes;
            Response it;
            block11: {
                Object object2;
                block10: {
                    it = (Response)closeable;
                    boolean bl = false;
                    object2 = it.body();
                    if (object2 == null) break block10;
                    byte[] byArray = object2.bytes();
                    object2 = byArray;
                    if (byArray != null) break block11;
                }
                object2 = bytes = (Object)new byte[0];
            }
            if (!it.isSuccessful()) {
                String responseBodyAsString = new String((byte[])bytes, Charsets.UTF_8);
                this.handleExceptions(it.code(), (String)CollectionsKt.first((List)request2.url().pathSegments()), responseBodyAsString);
            }
            object = bytes;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String executeJsonRequest(String pathSegment, Object body) {
        String string;
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        String string2 = this.mapper.writeValueAsString(body);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mapper.writeValueAsString(body)");
        RequestBody bodyData = RequestBody.Companion.create(string2, mediaType);
        Request.Builder builder = new Request.Builder().addHeader("Content-Type", "application/json");
        XCTestClient xCTestClient = this.client;
        if (xCTestClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            xCTestClient = null;
        }
        Request.Builder requestBuilder = builder.url(xCTestClient.xctestAPIBuilder(pathSegment).build()).post(bodyData);
        Closeable closeable = (Closeable)this.okHttpClient.newCall(requestBuilder.build()).execute();
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            string = this.processResponse(it, pathSegment);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String executeJsonRequest(String pathSegment) {
        String string;
        Request.Builder builder = new Request.Builder();
        XCTestClient xCTestClient = this.client;
        if (xCTestClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            xCTestClient = null;
        }
        Request.Builder requestBuilder = builder.url(xCTestClient.xctestAPIBuilder(pathSegment).build()).get();
        Closeable closeable = (Closeable)this.okHttpClient.newCall(requestBuilder.build()).execute();
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            string = this.processResponse(it, pathSegment);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String processResponse(Response response, String url) {
        v0 /* !! */  = response.body();
        if (v0 /* !! */  == null) ** GOTO lbl-1000
        v1 = v0 /* !! */ .bytes();
        v0 /* !! */  = (ResponseBody)v1;
        if (v1 != null) {
            bytes /* !! */  = v0 /* !! */ ;
            $i$a$-let-XCTestDriverClient$processResponse$responseBodyAsString$1 = false;
            v2 = new String((byte[])bytes /* !! */ , Charsets.UTF_8);
        } else lbl-1000:
        // 2 sources

        {
            v2 = responseBodyAsString = "";
        }
        if (!response.isSuccessful()) {
            code = response.code();
            v3 = this.handleExceptions(code, url, responseBodyAsString);
        } else {
            v3 = responseBodyAsString;
        }
        return v3;
    }

    private final String handleExceptions(int code, String pathString, String responseBodyAsString) {
        Error error = (Error)this.mapper.readValue(responseBodyAsString, Error.class);
        boolean bl = 400 <= code ? code < 500 : false;
        if (bl) {
            this.logger.error("Request for " + pathString + " failed with bad request " + code + ", body: " + responseBodyAsString);
            String string = "Request for " + pathString + " failed with bad request " + code + ", body: " + responseBodyAsString;
            Intrinsics.checkNotNullExpressionValue((Object)error, (String)"error");
            throw new XCUITestServerError.BadRequest(string, error);
        }
        CharSequence charSequence = error.getErrorMessage();
        if (new Regex("Lost connection to the application.*").containsMatchIn(charSequence)) {
            this.logger.error("Request for " + pathString + " failed, because of app crash, body: " + responseBodyAsString);
            throw new XCUITestServerError.AppCrash("Request for " + pathString + " failed, due to app crash with message " + error.getErrorMessage());
        }
        charSequence = error.getErrorMessage();
        if (new Regex("Application [a-zA-Z0-9.]+ is not running").containsMatchIn(charSequence)) {
            this.logger.error("Request for " + pathString + " failed, because of app crash, body: " + responseBodyAsString);
            throw new XCUITestServerError.AppCrash("Request for " + pathString + " failed, due to app crash with message " + error.getErrorMessage());
        }
        if (StringsKt.contains$default((CharSequence)error.getErrorMessage(), (CharSequence)"Error getting main window kAXErrorCannotComplete", (boolean)false, (int)2, null)) {
            this.logger.error("Request for " + pathString + " failed, because of app crash, body: " + responseBodyAsString);
            throw new XCUITestServerError.AppCrash("Request for " + pathString + " failed, due to app crash with message " + error.getErrorMessage());
        }
        charSequence = error.getErrorMessage();
        if (new Regex("Error getting main window.*").containsMatchIn(charSequence)) {
            this.logger.error("Request for " + pathString + " failed, because of app crash, body: " + responseBodyAsString);
            throw new XCUITestServerError.AppCrash("Request for " + pathString + " failed, due to app crash with message " + error.getErrorMessage());
        }
        this.logger.error("Request for " + pathString + " failed, because of unknown reason, body: " + responseBodyAsString);
        throw new XCUITestServerError.UnknownFailure("Request for " + pathString + " failed, code: " + code + ", body: " + responseBodyAsString);
    }

    private static final void _init_$lambda$0(XCTestDriverClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isShuttingDown = true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lxcuitest/XCTestDriverClient$XCTestDriverUnreachable;", "Ljava/io/IOException;", "message", "", "(Ljava/lang/String;)V", "maestro-ios-driver"})
    public static final class XCTestDriverUnreachable
    extends IOException {
        public XCTestDriverUnreachable(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

