/*
 * Decompiled with CFR 0.152.
 */
package maestro.orchestra.geo;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import maestro.Maestro;
import maestro.orchestra.TravelCommand;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lmaestro/orchestra/geo/Traveller;", "", "()V", "travel", "", "maestro", "Lmaestro/Maestro;", "points", "", "Lmaestro/orchestra/TravelCommand$GeoPoint;", "speedMPS", "", "start", "end", "maestro-orchestra"})
public final class Traveller {
    @NotNull
    public static final Traveller INSTANCE = new Traveller();

    private Traveller() {
    }

    public final void travel(@NotNull Maestro maestro, @NotNull List<TravelCommand.GeoPoint> points, double speedMPS) {
        Intrinsics.checkNotNullParameter((Object)maestro, (String)"maestro");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.isEmpty()) {
            return;
        }
        LinkedList pointsQueue = new LinkedList(points);
        TravelCommand.GeoPoint start = (TravelCommand.GeoPoint)pointsQueue.poll();
        maestro.setLocation(start.getLatitude(), start.getLongitude());
        do {
            TravelCommand.GeoPoint next;
            if ((TravelCommand.GeoPoint)pointsQueue.poll() == null) {
                return;
            }
            TravelCommand.GeoPoint geoPoint = start;
            Intrinsics.checkNotNullExpressionValue((Object)geoPoint, (String)"start");
            this.travel(maestro, geoPoint, next, speedMPS);
            start = next;
        } while (!((Collection)pointsQueue).isEmpty());
    }

    private final void travel(Maestro maestro, TravelCommand.GeoPoint start, TravelCommand.GeoPoint end, double speedMPS) {
        int steps = 50;
        double distance = start.getDistanceInMeters(end);
        double timeToTravel = distance / speedMPS;
        long timeToTravelInMilliseconds = (long)(timeToTravel * (double)1000);
        long timeToSleep = timeToTravelInMilliseconds / (long)steps;
        double sLat = Double.parseDouble(start.getLatitude());
        double sLon = Double.parseDouble(start.getLongitude());
        double eLat = Double.parseDouble(end.getLatitude());
        double eLon = Double.parseDouble(end.getLongitude());
        double latitudeStep = (eLat - sLat) / (double)steps;
        double longitudeStep = (eLon - sLon) / (double)steps;
        int i = 1;
        while (true) {
            double latitude = sLat + latitudeStep * (double)i;
            double longitude = sLon + longitudeStep * (double)i;
            maestro.setLocation(String.valueOf(latitude), String.valueOf(longitude));
            Thread.sleep(timeToSleep);
            if (i == steps) break;
            ++i;
        }
    }
}

