/*
 * Decompiled with CFR 0.152.
 */
package maestro.orchestra.workspace;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import maestro.orchestra.error.ValidationError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a8\u0006\u0010"}, d2={"Lmaestro/orchestra/workspace/YamlCommandsPathValidator;", "", "()V", "validateInsideWorkspace", "", "workspace", "", "Ljava/nio/file/Path;", "pathString", "", "validatePathsExistInWorkspace", "", "input", "flowFile", "pathStrings", "", "maestro-orchestra"})
@SourceDebugExtension(value={"SMAP\nYamlCommandsPathValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlCommandsPathValidator.kt\nmaestro/orchestra/workspace/YamlCommandsPathValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1855#2,2:25\n1747#2,3:28\n1#3:27\n*S KotlinDebug\n*F\n+ 1 YamlCommandsPathValidator.kt\nmaestro/orchestra/workspace/YamlCommandsPathValidator\n*L\n11#1:25,2\n21#1:28,3\n*E\n"})
public final class YamlCommandsPathValidator {
    @NotNull
    public static final YamlCommandsPathValidator INSTANCE = new YamlCommandsPathValidator();

    private YamlCommandsPathValidator() {
    }

    public final void validatePathsExistInWorkspace(@NotNull Set<? extends Path> input, @NotNull Path flowFile, @NotNull List<String> pathStrings) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)flowFile, (String)"flowFile");
        Intrinsics.checkNotNullParameter(pathStrings, (String)"pathStrings");
        Iterable $this$forEach$iv = pathStrings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            boolean exists = INSTANCE.validateInsideWorkspace(input, it);
            if (exists) continue;
            throw new ValidationError("The File \"" + Paths.get(it, new String[0]).getFileName() + "\" referenced in flow file: " + flowFile + " not found in workspace");
        }
    }

    private final boolean validateInsideWorkspace(Set<? extends Path> workspace, String pathString) {
        boolean bl;
        block5: {
            Object object;
            block4: {
                for (Path it : (Iterable)workspace) {
                    boolean bl2 = false;
                    Path path = it.resolve(it.getFileSystem().getPath(pathString, new String[0]));
                    if (path == null) continue;
                    object = path;
                    break block4;
                }
                object = null;
            }
            Object mediaPath = object;
            Iterable $this$any$iv = workspace;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Path it = (Path)element$iv;
                    boolean bl3 = false;
                    if (!Files.walk(it, new FileVisitOption[0]).anyMatch(arg_0 -> YamlCommandsPathValidator.validateInsideWorkspace$lambda$3$lambda$2((Function1)new Function1<Path, Boolean>((Path)mediaPath){
                        final /* synthetic */ Path $mediaPath;
                        {
                            this.$mediaPath = $mediaPath;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(Path path) {
                            Path path2 = this.$mediaPath;
                            return Intrinsics.areEqual((Object)path.getFileName(), (Object)(path2 != null ? path2.getFileName() : null));
                        }
                    }, arg_0))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean validateInsideWorkspace$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

