/*
 * Decompiled with CFR 0.152.
 */
package maestro.orchestra.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import maestro.orchestra.ApplyConfigurationCommand;
import maestro.orchestra.MaestroCommand;
import maestro.orchestra.MaestroConfig;
import maestro.orchestra.WorkspaceConfig;
import maestro.orchestra.error.SyntaxError;
import maestro.orchestra.util.Env;
import maestro.orchestra.yaml.YamlConfig;
import maestro.orchestra.yaml.YamlFluentCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0015\u001a\u00020\u000fJ)\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u000fJ\"\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\n0\u001f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lmaestro/orchestra/yaml/YamlCommandReader;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMAPPER", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getConfig", "Lmaestro/orchestra/MaestroConfig;", "commands", "", "Lmaestro/orchestra/MaestroCommand;", "getErrorMessage", "", "path", "Ljava/nio/file/Path;", "e", "", "getJsonProcessingException", "Lcom/fasterxml/jackson/core/JsonProcessingException;", "getWatchFiles", "flowPath", "mapParsingErrors", "T", "block", "Lkotlin/Function0;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readCommands", "readConfig", "Lmaestro/orchestra/yaml/YamlConfig;", "readConfigAndCommands", "Lkotlin/Pair;", "Lmaestro/orchestra/yaml/YamlFluentCommand;", "readWorkspaceConfig", "Lmaestro/orchestra/WorkspaceConfig;", "configPath", "maestro-orchestra"})
@SourceDebugExtension(value={"SMAP\nYamlCommandReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlCommandReader.kt\nmaestro/orchestra/yaml/YamlCommandReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1549#2:150\n1620#2,3:151\n800#2,11:154\n766#2:165\n857#2,2:166\n*S KotlinDebug\n*F\n+ 1 YamlCommandReader.kt\nmaestro/orchestra/yaml/YamlCommandReader\n*L\n80#1:150\n80#1:151,3\n81#1:154,11\n96#1:165\n96#1:166,2\n*E\n"})
public final class YamlCommandReader {
    @NotNull
    public static final YamlCommandReader INSTANCE;
    @NotNull
    private static final ObjectMapper MAPPER;

    private YamlCommandReader() {
    }

    @NotNull
    public final ObjectMapper getMAPPER() {
        return MAPPER;
    }

    @NotNull
    public final List<MaestroCommand> readCommands(@NotNull Path flowPath) {
        Intrinsics.checkNotNullParameter((Object)flowPath, (String)"flowPath");
        return (List)this.mapParsingErrors(flowPath, (Function0)new Function0<List<? extends MaestroCommand>>(flowPath){
            final /* synthetic */ Path $flowPath;
            {
                this.$flowPath = $flowPath;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MaestroCommand> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Pair pair = YamlCommandReader.access$readConfigAndCommands(YamlCommandReader.INSTANCE, this.$flowPath);
                YamlConfig config = (YamlConfig)pair.component1();
                List commands2 = (List)pair.component2();
                Iterable iterable = commands2;
                Path path = this.$flowPath;
                Env env = Env.INSTANCE;
                boolean $i$f$flatMap = false;
                void var8_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    YamlFluentCommand it = (YamlFluentCommand)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.toCommands(path, config.getAppId());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List maestroCommands = env.withEnv((List)destination$iv$iv, config.getEnv());
                iterable = new SpreadBuilder(2);
                iterable.add(config.toCommand(this.$flowPath));
                Collection $this$toTypedArray$iv = maestroCommands;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                iterable.addSpread(thisCollection$iv.toArray(new MaestroCommand[0]));
                return CollectionsKt.listOfNotNull((Object[])iterable.toArray(new MaestroCommand[iterable.size()]));
            }
        });
    }

    @NotNull
    public final YamlConfig readConfig(@NotNull Path flowPath) {
        Intrinsics.checkNotNullParameter((Object)flowPath, (String)"flowPath");
        YamlConfig config = (YamlConfig)this.readConfigAndCommands(flowPath).component1();
        return config;
    }

    @NotNull
    public final WorkspaceConfig readWorkspaceConfig(@NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        return (WorkspaceConfig)this.mapParsingErrors(configPath, (Function0)new Function0<WorkspaceConfig>(configPath){
            final /* synthetic */ Path $configPath;
            {
                this.$configPath = $configPath;
                super(0);
            }

            @NotNull
            public final WorkspaceConfig invoke() {
                String config = PathsKt.readText$default((Path)this.$configPath, null, (int)1, null);
                if (StringsKt.isBlank((CharSequence)config)) {
                    return new WorkspaceConfig(null, null, null, null, null, 31, null);
                }
                Object object = YamlCommandReader.INSTANCE.getMAPPER().readValue(config, WorkspaceConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAPPER.readValue(config,\u2026kspaceConfig::class.java)");
                return (WorkspaceConfig)object;
            }
        });
    }

    @NotNull
    public final List<Path> getWatchFiles(@NotNull Path flowPath) {
        Intrinsics.checkNotNullParameter((Object)flowPath, (String)"flowPath");
        return (List)this.mapParsingErrors(flowPath, (Function0)new Function0<List<? extends Path>>(flowPath){
            final /* synthetic */ Path $flowPath;
            {
                this.$flowPath = $flowPath;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Path> invoke() {
                void $this$filterTo$iv$iv;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                List commands2 = (List)YamlCommandReader.access$readConfigAndCommands(YamlCommandReader.INSTANCE, this.$flowPath).component2();
                Iterable iterable = commands2;
                Path path = this.$flowPath;
                boolean $i$f$flatMap22 = false;
                void var6_7 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    YamlFluentCommand it = (YamlFluentCommand)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getWatchFiles(path);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List commandWatchFiles = (List)destination$iv$iv;
                Iterable $this$filter$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.$flowPath), (Iterable)commandWatchFiles);
                boolean $i$f$filter = false;
                Iterable $i$f$flatMap22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    Path path2;
                    Path it = (Path)element$iv$iv;
                    boolean bl2 = false;
                    Path path3 = it.toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
                    Path path4 = path2 = path3.getParent();
                    if (path4 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"parent");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        bl = Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                return (List)destination$iv$iv2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MaestroConfig getConfig(@NotNull List<MaestroCommand> commands2) {
        ApplyConfigurationCommand configurationCommand;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(commands2, (String)"commands");
        Iterable $this$map$iv = commands2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MaestroCommand maestroCommand = (MaestroCommand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asCommand());
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ApplyConfigurationCommand)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ApplyConfigurationCommand applyConfigurationCommand = configurationCommand = (ApplyConfigurationCommand)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return applyConfigurationCommand != null ? applyConfigurationCommand.getConfig() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<YamlConfig, List<YamlFluentCommand>> readConfigAndCommands(Path flowPath) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String flowContent = PathsKt.readText$default((Path)flowPath, null, (int)1, null);
        JsonParser parser = MAPPER.createParser(flowContent);
        Iterator iterator = parser.readValuesAs(JsonNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"parser.readValuesAs(JsonNode::class.java)");
        Iterable iterable = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl = false;
            if (!(!it.isNull())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int sectionCount = ((List)destination$iv$iv).size();
        if (sectionCount != 2) {
            throw new SyntaxError("Flow files must contain a config section and a commands section separated by \"---\". For example:\n\nappId: com.example\n---\n- launchApp");
        }
        parser = MAPPER.createParser(flowContent);
        Object object = parser.readValueAs(YamlConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parser.readValueAs(YamlConfig::class.java)");
        YamlConfig config = (YamlConfig)object;
        List commands2 = (List)parser.readValueAs((TypeReference)new TypeReference<List<? extends YamlFluentCommand>>(){});
        return TuplesKt.to((Object)YamlConfig.copy$default(config, null, null, null, config.getEnv(), null, null, null, 119, null), (Object)commands2);
    }

    private final <T> T mapParsingErrors(Path path, Function0<? extends T> block) {
        try {
            return (T)block.invoke();
        }
        catch (Throwable e) {
            String message2 = this.getErrorMessage(path, e);
            throw new SyntaxError(message2);
        }
    }

    private final String getErrorMessage(Path path, Throwable e) {
        String prefix = "Failed to parse file: " + ((Object)path.toAbsolutePath()).toString();
        JsonProcessingException jsonProcessingException = this.getJsonProcessingException(e);
        if (jsonProcessingException == null) {
            StringBuilder stringBuilder = new StringBuilder().append(prefix).append('\n');
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            return stringBuilder.append(string).toString();
        }
        JsonProcessingException jsonException = jsonProcessingException;
        JsonLocation jsonLocation = jsonException.getLocation();
        int lineNumber = jsonLocation != null ? jsonLocation.getLineNr() : -1;
        String originalMessage = jsonException.getOriginalMessage();
        String header = lineNumber != -1 ? prefix + ':' + lineNumber : prefix;
        return header + '\n' + originalMessage;
    }

    private final JsonProcessingException getJsonProcessingException(Throwable e) {
        if (e instanceof JsonProcessingException) {
            return (JsonProcessingException)e;
        }
        Throwable cause = e.getCause();
        if (cause == null || Intrinsics.areEqual((Object)cause, (Object)e)) {
            return null;
        }
        return this.getJsonProcessingException(cause);
    }

    public static final /* synthetic */ Pair access$readConfigAndCommands(YamlCommandReader $this, Path flowPath) {
        return $this.readConfigAndCommands(flowPath);
    }

    static {
        YAMLFactory yAMLFactory;
        INSTANCE = new YamlCommandReader();
        YAMLFactory $this$MAPPER_u24lambda_u240 = yAMLFactory = new YAMLFactory();
        boolean bl = false;
        $this$MAPPER_u24lambda_u240.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        JsonFactory jsonFactory = (JsonFactory)yAMLFactory;
        YAMLFactory $this$MAPPER_u24lambda_u241 = yAMLFactory = new ObjectMapper(jsonFactory);
        boolean bl2 = false;
        $this$MAPPER_u24lambda_u241.registerModule((Module)new KotlinModule.Builder().build());
        MAPPER = yAMLFactory;
    }
}

