/*
 * Decompiled with CFR 0.152.
 */
package maestro.orchestra.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import maestro.orchestra.AirplaneValue;
import maestro.orchestra.yaml.YamlSetAirplaneMode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lmaestro/orchestra/yaml/YamlSetAirplaneModeDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lmaestro/orchestra/yaml/YamlSetAirplaneMode;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "getLabel", "", "root", "Lcom/fasterxml/jackson/core/TreeNode;", "throwInvalidInputException", "", "input", "", "maestro-orchestra"})
public final class YamlSetAirplaneModeDeserializer
extends JsonDeserializer<YamlSetAirplaneMode> {
    @NotNull
    public YamlSetAirplaneMode deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        ObjectCodec objectCodec = parser.getCodec();
        Intrinsics.checkNotNull((Object)objectCodec, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.ObjectMapper");
        ObjectMapper mapper = (ObjectMapper)objectCodec;
        TreeNode treeNode = mapper.readTree(parser);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"mapper.readTree(parser)");
        TreeNode root = treeNode;
        Iterator iterator = root.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"root.fieldNames()");
        List input = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
        String label = this.getLabel(root);
        if (input.contains("value")) {
            AirplaneValue airplaneValue;
            String parsedValue = StringsKt.replace$default((String)root.get("value").toString(), (String)"\"", (String)"", (boolean)false, (int)4, null);
            String string = parsedValue;
            if (Intrinsics.areEqual((Object)string, (Object)"enabled")) {
                airplaneValue = AirplaneValue.Enable;
            } else if (Intrinsics.areEqual((Object)string, (Object)"disabled")) {
                airplaneValue = AirplaneValue.Disable;
            } else {
                this.throwInvalidInputException(input);
                throw new KotlinNothingValueException();
            }
            AirplaneValue returnValue = airplaneValue;
            return new YamlSetAirplaneMode(returnValue, label, false, 4, null);
        }
        if (root.isValueNode() && StringsKt.contains$default((CharSequence)root.toString(), (CharSequence)"enabled", (boolean)false, (int)2, null)) {
            return new YamlSetAirplaneMode(AirplaneValue.Enable, label, false, 4, null);
        }
        if (root.isValueNode() && StringsKt.contains$default((CharSequence)root.toString(), (CharSequence)"disabled", (boolean)false, (int)2, null)) {
            return new YamlSetAirplaneMode(AirplaneValue.Disable, label, false, 4, null);
        }
        this.throwInvalidInputException(input);
        throw new KotlinNothingValueException();
    }

    private final Void throwInvalidInputException(List<String> input) {
        throw new IllegalArgumentException("setAirplaneMode command takes either: \n\t1. enabled: To enable airplane mode\n\t2. disabled: To disable airplane mode\n\t3. value: To set airplane mode to a specific value (enabled or disabled) \nIt seems you provided invalid input with: " + input);
    }

    private final String getLabel(TreeNode root) {
        return root.path("label").isMissingNode() ? null : StringsKt.replace$default((String)root.path("label").toString(), (String)"\"", (String)"", (boolean)false, (int)4, null);
    }
}

