/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.verify;

import dev.mokkery.annotations.InternalMokkeryApi;
import dev.mokkery.verify.ExhaustiveOrderVerifyMode;
import dev.mokkery.verify.ExhaustiveSoftVerifyMode;
import dev.mokkery.verify.NotVerifyMode;
import dev.mokkery.verify.OrderVerifyMode;
import dev.mokkery.verify.SoftVerifyMode;
import dev.mokkery.verify.VerifyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Ldev/mokkery/verify/VerifyModeSerializer;", "", "()V", "deserialize", "Ldev/mokkery/verify/VerifyMode;", "value", "", "serialize", "verifyMode", "mokkery-core"})
@InternalMokkeryApi
@SourceDebugExtension(value={"SMAP\nVerifyMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyMode.kt\ndev/mokkery/verify/VerifyModeSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class VerifyModeSerializer {
    @NotNull
    public static final VerifyModeSerializer INSTANCE = new VerifyModeSerializer();

    private VerifyModeSerializer() {
    }

    @NotNull
    public final String serialize(@NotNull VerifyMode verifyMode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)verifyMode, (String)"verifyMode");
        VerifyMode verifyMode2 = verifyMode;
        if (Intrinsics.areEqual((Object)verifyMode2, (Object)ExhaustiveOrderVerifyMode.INSTANCE)) {
            string = "ExhaustiveOrder";
        } else if (Intrinsics.areEqual((Object)verifyMode2, (Object)ExhaustiveSoftVerifyMode.INSTANCE)) {
            string = "ExhaustiveSoft";
        } else if (Intrinsics.areEqual((Object)verifyMode2, (Object)NotVerifyMode.INSTANCE)) {
            string = "Not";
        } else if (Intrinsics.areEqual((Object)verifyMode2, (Object)OrderVerifyMode.INSTANCE)) {
            string = "Order";
        } else if (verifyMode2 instanceof SoftVerifyMode) {
            string = "Soft_" + ((SoftVerifyMode)verifyMode).getAtLeast() + '_' + ((SoftVerifyMode)verifyMode).getAtMost();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final VerifyMode deserialize(@NotNull String value) {
        VerifyMode verifyMode;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)"ExhaustiveOrder")) {
            verifyMode = ExhaustiveOrderVerifyMode.INSTANCE;
        } else if (Intrinsics.areEqual((Object)value, (Object)"ExhaustiveSoft")) {
            verifyMode = ExhaustiveSoftVerifyMode.INSTANCE;
        } else if (Intrinsics.areEqual((Object)value, (Object)"Not")) {
            verifyMode = NotVerifyMode.INSTANCE;
        } else if (Intrinsics.areEqual((Object)value, (Object)"Order")) {
            verifyMode = OrderVerifyMode.INSTANCE;
        } else if (StringsKt.startsWith$default((String)value, (String)"Soft", (boolean)false, (int)2, null)) {
            String it = StringsKt.removePrefix((String)value, (CharSequence)"Soft_");
            boolean bl = false;
            verifyMode = new SoftVerifyMode(Integer.parseInt(StringsKt.substringBefore$default((String)it, (String)"_", null, (int)2, null)), Integer.parseInt(StringsKt.substringAfter$default((String)it, (String)"_", null, (int)2, null)));
        } else {
            throw new IllegalStateException("Unknown verify mode!".toString());
        }
        return verifyMode;
    }
}

