/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin;

import com.google.auto.service.AutoService;
import dev.mokkery.MockMode;
import dev.mokkery.plugin.MokkeryCommandLineProcessorKt;
import dev.mokkery.verify.VerifyModeSerializer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ldev/mokkery/plugin/MokkeryCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "getPluginOptions", "()Ljava/util/Collection;", "processOption", "", "option", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "mokkery-plugin"})
@AutoService(value={CommandLineProcessor.class})
public final class MokkeryCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    private final String pluginId;
    @NotNull
    private final Collection<AbstractCliOption> pluginOptions;

    public MokkeryCommandLineProcessor() {
        this.pluginId = "dev.mokkery";
        Object[] objectArray = new CliOption[2];
        String string = MokkeryCommandLineProcessorKt.getMOCK_MODE_KEY().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MOCK_MODE_KEY.toString()");
        objectArray[0] = new CliOption(string, "enum class dev.mokkery.MockMode", "Default MockMode for every mock.", true, false);
        String string2 = MokkeryCommandLineProcessorKt.getVERIFY_MODE_KEY().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VERIFY_MODE_KEY.toString()");
        objectArray[1] = new CliOption(string2, "sealed class dev.mokkery.VerifyMode", "Default VerifyMode for every verify block.", true, false);
        this.pluginOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public Collection<AbstractCliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = option.getOptionName();
        if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getMOCK_MODE_KEY().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getMOCK_MODE_KEY(), (Object)MockMode.valueOf((String)value));
        } else if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getVERIFY_MODE_KEY().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getVERIFY_MODE_KEY(), (Object)VerifyModeSerializer.INSTANCE.deserialize(value));
        } else {
            throw new IllegalStateException(("Unknown config option: " + option).toString());
        }
    }
}

