/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin;

import dev.mokkery.MockMode;
import dev.mokkery.plugin.transformers.CallTrackingTransformer;
import dev.mokkery.plugin.transformers.MockCallsTransformer;
import dev.mokkery.plugin.transformers.SpyCallsTransformer;
import dev.mokkery.verify.VerifyMode;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/mokkery/plugin/MokkeryIrGenerationExtension;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "mockMode", "Ldev/mokkery/MockMode;", "verifyMode", "Ldev/mokkery/verify/VerifyMode;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ldev/mokkery/MockMode;Ldev/mokkery/verify/VerifyMode;)V", "mockTable", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "spyTable", "generate", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "mokkery-plugin"})
@SourceDebugExtension(value={"SMAP\nMokkeryIrGenerationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MokkeryIrGenerationExtension.kt\ndev/mokkery/plugin/MokkeryIrGenerationExtension\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MessageCollectorUtils.kt\ndev/mokkery/plugin/MessageCollectorUtilsKt\n*L\n1#1,56:1\n18#2,4:57\n50#2,6:61\n56#2:71\n1855#3,2:67\n1855#3,2:69\n11#4,2:72\n*S KotlinDebug\n*F\n+ 1 MokkeryIrGenerationExtension.kt\ndev/mokkery/plugin/MokkeryIrGenerationExtension\n*L\n27#1:57,4\n27#1:61,6\n27#1:71\n28#1:67,2\n44#1:69,2\n53#1:72,2\n*E\n"})
public final class MokkeryIrGenerationExtension
implements IrGenerationExtension {
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final MockMode mockMode;
    @NotNull
    private final VerifyMode verifyMode;
    @NotNull
    private final Map<IrClass, IrClass> mockTable;
    @NotNull
    private final Map<IrClass, IrClass> spyTable;

    public MokkeryIrGenerationExtension(@NotNull MessageCollector messageCollector, @NotNull MockMode mockMode, @NotNull VerifyMode verifyMode) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)mockMode, (String)"mockMode");
        Intrinsics.checkNotNullParameter((Object)verifyMode, (String)"verifyMode");
        this.messageCollector = messageCollector;
        this.mockMode = mockMode;
        this.verifyMode = verifyMode;
        this.mockTable = new LinkedHashMap();
        this.spyTable = new LinkedHashMap();
    }

    public void generate(@NotNull IrModuleFragment moduleFragment, @NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Iterable $this$forEach$iv = moduleFragment.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile irFile = (IrFile)element$iv;
            boolean bl2 = false;
            new MockCallsTransformer(pluginContext, this.messageCollector, irFile, this.mockTable, this.mockMode).visitFile(irFile);
            new SpyCallsTransformer(pluginContext, this.messageCollector, irFile, this.spyTable).visitFile(irFile);
        }
        Map interceptedTypesTable = MapsKt.plus(this.mockTable, this.spyTable);
        Iterable $this$forEach$iv2 = moduleFragment.getFiles();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IrFile irFile = (IrFile)element$iv;
            boolean bl3 = false;
            new CallTrackingTransformer(irFile, pluginContext, interceptedTypesTable, this.verifyMode).visitFile(irFile);
        }
        long time = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        MessageCollector $this$log$iv = this.messageCollector;
        boolean $i$f$log = false;
        StringBuilder stringBuilder = new StringBuilder().append("dev.mokkery: ");
        CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
        MessageCollector messageCollector = $this$log$iv;
        boolean bl4 = false;
        String string = "Plugin time: " + Duration.toString-impl((long)time);
        MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)compilerMessageSeverity, (String)stringBuilder.append(string).toString(), null, (int)4, null);
    }

    @Nullable
    public IrDeclaration resolveSymbol(@NotNull IrSymbol symbol, @NotNull TranslationPluginContext context) {
        return IrGenerationExtension.DefaultImpls.resolveSymbol((IrGenerationExtension)this, (IrSymbol)symbol, (TranslationPluginContext)context);
    }
}

