/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin.diagnostics;

import dev.mokkery.plugin.core.Mokkery;
import dev.mokkery.plugin.diagnostics.MokkeryScopedCallsChecker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u001b"}, d2={"Ldev/mokkery/plugin/diagnostics/MokkeryCallsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "every", "Lorg/jetbrains/kotlin/name/CallableId;", "getEvery", "()Lorg/jetbrains/kotlin/name/CallableId;", "everySuspend", "getEverySuspend", "mock", "spy", "getSpy", "verify", "getVerify", "verifySuspend", "getVerifySuspend", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "mokkery-plugin"})
public final class MokkeryCallsChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final CallableId mock;
    @NotNull
    private final CallableId spy;
    @NotNull
    private final CallableId every;
    @NotNull
    private final CallableId everySuspend;
    @NotNull
    private final CallableId verify;
    @NotNull
    private final CallableId verifySuspend;

    public MokkeryCallsChecker(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.mock = Mokkery.Callable.INSTANCE.getMock();
        this.spy = Mokkery.Callable.INSTANCE.getSpy();
        this.every = Mokkery.Callable.INSTANCE.getEvery();
        this.everySuspend = Mokkery.Callable.INSTANCE.getEverySuspend();
        this.verify = Mokkery.Callable.INSTANCE.getVerify();
        this.verifySuspend = Mokkery.Callable.INSTANCE.getVerifySuspend();
    }

    @NotNull
    public final CallableId getSpy() {
        return this.spy;
    }

    @NotNull
    public final CallableId getEvery() {
        return this.every;
    }

    @NotNull
    public final CallableId getEverySuspend() {
        return this.everySuspend;
    }

    @NotNull
    public final CallableId getVerify() {
        return this.verify;
    }

    @NotNull
    public final CallableId getVerifySuspend() {
        return this.verifySuspend;
    }

    public void check(@NotNull FirFunctionCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirNamedReference firNamedReference = expression.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference callee = firResolvedNamedReference;
        FirBasedSymbol firBasedSymbol = callee.getResolvedSymbol();
        FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol symbol = firNamedFunctionSymbol;
        MokkeryScopedCallsChecker scope = new MokkeryScopedCallsChecker(this.session, expression, context, reporter, symbol);
        firBasedSymbol = symbol.getCallableId();
        if (Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.mock) ? true : Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.spy)) {
            scope.checkInterception();
        } else if (((Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.every) ? true : Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.everySuspend)) ? true : Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.verify)) ? true : Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.verifySuspend)) {
            scope.checkTemplating();
        }
    }
}

