/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin.diagnostics;

import dev.mokkery.plugin.diagnostics.MokkeryDiagnostics;
import dev.mokkery.plugin.diagnostics.MokkeryScopedCallsChecker;
import dev.mokkery.plugin.fir.UtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/mokkery/plugin/diagnostics/MokkeryScopedCallsChecker;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "funSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)V", "checkInterception", "", "checkInterceptionDefaultConstructor", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "typeArg", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "checkInterceptionFinalMembers", "checkInterceptionModality", "checkInterceptionTypeParameter", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkTemplating", "checkTemplatingFunctionalParam", "mokkery-plugin"})
@SourceDebugExtension(value={"SMAP\nMokkeryCallsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MokkeryCallsChecker.kt\ndev/mokkery/plugin/diagnostics/MokkeryScopedCallsChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,167:1\n46#2:168\n2624#3,3:169\n46#4:172\n*S KotlinDebug\n*F\n+ 1 MokkeryCallsChecker.kt\ndev/mokkery/plugin/diagnostics/MokkeryScopedCallsChecker\n*L\n95#1:168\n113#1:169,3\n153#1:172\n*E\n"})
final class MokkeryScopedCallsChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirFunctionCall expression;
    @NotNull
    private final CheckerContext context;
    @NotNull
    private final DiagnosticReporter reporter;
    @NotNull
    private final FirNamedFunctionSymbol funSymbol;

    public MokkeryScopedCallsChecker(@NotNull FirSession session, @NotNull FirFunctionCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirNamedFunctionSymbol funSymbol) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)funSymbol, (String)"funSymbol");
        this.session = session;
        this.expression = expression;
        this.context = context;
        this.reporter = reporter;
        this.funSymbol = funSymbol;
    }

    public final void checkInterception() {
        FirTypeProjection typeArg = (FirTypeProjection)CollectionsKt.first((List)this.expression.getTypeArguments());
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)typeArg));
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType type = coneKotlinType;
        this.checkInterceptionTypeParameter(type, typeArg);
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)type, (FirSession)this.session);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        this.checkInterceptionModality(classSymbol, typeArg);
        this.checkInterceptionDefaultConstructor(classSymbol, typeArg);
        this.checkInterceptionFinalMembers(classSymbol, typeArg);
    }

    public final void checkTemplating() {
        this.checkTemplatingFunctionalParam();
    }

    private final void checkInterceptionTypeParameter(ConeKotlinType type, FirTypeProjection typeArg) {
        if (type instanceof ConeTypeParameterType) {
            KtSourceElement ktSourceElement = typeArg.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = this.expression.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), MokkeryDiagnostics.INSTANCE.getINDIRECT_INTERCEPTION(), (Object)this.funSymbol.getName(), (Object)type, (DiagnosticContext)((DiagnosticContext)this.context), null, (int)32, null);
        }
    }

    private final void checkInterceptionModality(FirRegularClassSymbol classSymbol, FirTypeProjection typeArg) {
        KtDiagnosticFactory2<Name, ConeKotlinType> modalityDiagnostic;
        FirClassLikeSymbol $this$modality$iv = (FirClassLikeSymbol)classSymbol;
        boolean $i$f$getModality = false;
        Modality modality = $this$modality$iv.getResolvedStatus().getModality();
        switch (modality == null ? -1 : WhenMappings.$EnumSwitchMapping$0[modality.ordinal()]) {
            case 1: {
                KtDiagnosticFactory2<Name, ConeKotlinType> ktDiagnosticFactory2 = MokkeryDiagnostics.INSTANCE.getSEALED_TYPE_CANNOT_BE_INTERCEPTED();
                break;
            }
            case 2: {
                KtDiagnosticFactory2<Name, ConeKotlinType> ktDiagnosticFactory2 = MokkeryDiagnostics.INSTANCE.getFINAL_TYPE_CANNOT_BE_INTERCEPTED();
                break;
            }
            default: {
                KtDiagnosticFactory2<Name, ConeKotlinType> ktDiagnosticFactory2 = modalityDiagnostic = null;
            }
        }
        if (modalityDiagnostic != null) {
            KtSourceElement ktSourceElement = typeArg.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = this.expression.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), modalityDiagnostic, (Object)this.funSymbol.getName(), (Object)ScopeUtilsKt.defaultType((FirClassSymbol)((FirClassSymbol)classSymbol)), (DiagnosticContext)((DiagnosticContext)this.context), null, (int)32, null);
        }
    }

    private final void checkInterceptionDefaultConstructor(FirRegularClassSymbol classSymbol, FirTypeProjection typeArg) {
        List<FirConstructorSymbol> constructors = UtilsKt.getConstructors(classSymbol);
        if (CollectionsKt.any((Iterable)constructors)) {
            boolean bl;
            block6: {
                Iterable $this$none$iv = constructors;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                        boolean bl2 = false;
                        if (!UtilsKt.isDefault(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                KtSourceElement ktSourceElement = typeArg.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = this.expression.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), MokkeryDiagnostics.INSTANCE.getNO_DEFAULT_CONSTRUCTOR_TYPE_CANNOT_BE_INTERCEPTED(), (Object)this.funSymbol.getName(), (Object)ScopeUtilsKt.defaultType((FirClassSymbol)((FirClassSymbol)classSymbol)), (DiagnosticContext)((DiagnosticContext)this.context), null, (int)32, null);
            }
        }
    }

    private final void checkInterceptionFinalMembers(FirRegularClassSymbol classSymbol, FirTypeProjection typeArg) {
        Sequence inheritedSymbols2 = SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)classSymbol.getResolvedSuperTypes()), (Function1)((Function1)new Function1<ConeKotlinType, FirRegularClassSymbol>(this){
            final /* synthetic */ MokkeryScopedCallsChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final FirRegularClassSymbol invoke(@NotNull ConeKotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)it, (FirSession)MokkeryScopedCallsChecker.access$getSession$p(this.this$0));
            }
        })), (Function1)checkInterceptionFinalMembers.inheritedSymbols.2.INSTANCE);
        Sequence allDeclarationSymbols = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)classSymbol.getDeclarationSymbols()), (Sequence)inheritedSymbols2);
        List finalDeclarations2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)allDeclarationSymbols, (Function1)checkInterceptionFinalMembers.finalDeclarations.1.INSTANCE));
        if (!((Collection)finalDeclarations2).isEmpty()) {
            KtSourceElement ktSourceElement = typeArg.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = this.expression.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), MokkeryDiagnostics.INSTANCE.getFINAL_MEMBERS_TYPE_CANNOT_BE_INTERCEPTED(), (Object)this.funSymbol.getName(), (Object)ScopeUtilsKt.defaultType((FirClassSymbol)((FirClassSymbol)classSymbol)), (Object)finalDeclarations2, (DiagnosticContext)((DiagnosticContext)this.context), null, (int)64, null);
            return;
        }
    }

    public final void checkTemplatingFunctionalParam() {
        FirCall $this$arguments$iv = (FirCall)this.expression;
        boolean $i$f$getArguments = false;
        FirExpression blockArgument = FirExpressionUtilKt.unwrapArgument((FirExpression)((FirExpression)CollectionsKt.last((List)$this$arguments$iv.getArgumentList().getArguments())));
        if (!(blockArgument instanceof FirAnonymousFunctionExpression)) {
            KtSourceElement ktSourceElement = blockArgument.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = this.expression.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), MokkeryDiagnostics.INSTANCE.getFUNCTIONAL_PARAM_MUST_BE_LAMBDA(), (Object)this.funSymbol.getName(), (Object)CollectionsKt.last((List)this.funSymbol.getValueParameterSymbols()), (DiagnosticContext)((DiagnosticContext)this.context), null, (int)32, null);
            return;
        }
    }

    public static final /* synthetic */ FirSession access$getSession$p(MokkeryScopedCallsChecker $this) {
        return $this.session;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Modality.values().length];
            try {
                nArray[Modality.SEALED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Modality.FINAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

