/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin.transformers;

import dev.mokkery.plugin.core.Cache;
import dev.mokkery.plugin.core.CacheKt;
import dev.mokkery.plugin.core.CompilerPluginScope;
import dev.mokkery.plugin.core.CoreTransformer;
import dev.mokkery.plugin.core.Mokkery;
import dev.mokkery.plugin.core.MokkeryConfigApiKt;
import dev.mokkery.plugin.core.TransformerScope;
import dev.mokkery.plugin.core.TransformerScopeApiKt;
import dev.mokkery.plugin.ir.IrBuilderWithScopeKt;
import dev.mokkery.plugin.ir.IrDeclarationKt;
import dev.mokkery.plugin.ir.IrExpressionKt;
import dev.mokkery.plugin.ir.IrTypeKt;
import dev.mokkery.plugin.transformers.CreateMockClassKt;
import dev.mokkery.plugin.transformers.CreateMockJsFunctionKt;
import dev.mokkery.plugin.transformers.CreateSpyClassKt;
import dev.mokkery.plugin.transformers.CreateSpyJsFunctionKt;
import dev.mokkery.plugin.transformers.MokkeryTransformer;
import dev.mokkery.plugin.transformers.TemplatingScopeCallsTransformer;
import dev.mokkery.verify.SoftVerifyMode;
import dev.mokkery.verify.VerifyMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0014\u0010!\u001a\u00020\"*\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010#\u001a\u00020\"*\u00020\u0014H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010\f*\u00020\u0014H\u0002J\u0014\u0010%\u001a\u00020\u0012*\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/mokkery/plugin/transformers/MokkeryTransformer;", "Ldev/mokkery/plugin/core/CoreTransformer;", "compilerPluginScope", "Ldev/mokkery/plugin/core/CompilerPluginScope;", "(Ldev/mokkery/plugin/core/CompilerPluginScope;)V", "internalEvery", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "internalEverySuspend", "internalVerify", "internalVerifySuspend", "mockCache", "Ldev/mokkery/plugin/core/Cache;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "spyCache", "getIrClassOf", "cls", "Lkotlin/reflect/KClass;", "replaceWithInternalEvery", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "replaceWithInternalVerify", "replaceWithMock", "call", "replaceWithSpy", "visitCall", "visitFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "declaration", "visitModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "assertFunctionExpressionThatOriginatesLambda", "", "checkInterceptionPossibilities", "getTypeToMock", "irGetVerifyMode", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "verifyMode", "Ldev/mokkery/verify/VerifyMode;", "mokkery-plugin"})
@SourceDebugExtension(value={"SMAP\nMokkeryTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MokkeryTransformer.kt\ndev/mokkery/plugin/transformers/MokkeryTransformer\n+ 2 MokkeryLogApi.kt\ndev/mokkery/plugin/core/MokkeryLogApiKt\n+ 3 TransformerScopeApi.kt\ndev/mokkery/plugin/core/TransformerScopeApiKt\n+ 4 IrBuilderWithScope.kt\ndev/mokkery/plugin/ir/IrBuilderWithScopeKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 7 IrBuilderWithScope.kt\ndev/mokkery/plugin/ir/IrBuilderWithScopeKt$irCall$2\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n26#2,2:263\n10#2,6:332\n10#2,6:339\n10#2,6:345\n10#2,6:351\n10#2,6:357\n10#2,6:363\n18#2,6:369\n29#3,5:265\n29#3,5:271\n29#3,5:277\n29#3,5:304\n188#4:270\n188#4:276\n160#4,5:296\n157#4:302\n160#4,5:323\n157#4:329\n188#4:331\n376#5,13:282\n376#5,13:309\n98#6:295\n99#6:303\n98#6:322\n99#6:330\n162#7:301\n162#7:328\n1#8:338\n*S KotlinDebug\n*F\n+ 1 MokkeryTransformer.kt\ndev/mokkery/plugin/transformers/MokkeryTransformer\n*L\n97#1:263,2\n192#1:332,6\n214#1:339,6\n219#1:345,6\n225#1:351,6\n231#1:357,6\n246#1:363,6\n258#1:369,6\n107#1:265,5\n125#1:271,5\n135#1:277,5\n155#1:304,5\n108#1:270\n126#1:276\n137#1:296,5\n143#1:302\n157#1:323,5\n163#1:329\n175#1:331\n136#1:282,13\n156#1:309,13\n136#1:295\n136#1:303\n156#1:322\n156#1:330\n137#1:301\n157#1:328\n*E\n"})
public final class MokkeryTransformer
extends CoreTransformer {
    @NotNull
    private final Cache<IrClass, IrClass> mockCache;
    @NotNull
    private final Cache<IrClass, IrClass> spyCache;
    @NotNull
    private final IrSimpleFunction internalEvery;
    @NotNull
    private final IrSimpleFunction internalEverySuspend;
    @NotNull
    private final IrSimpleFunction internalVerify;
    @NotNull
    private final IrSimpleFunction internalVerifySuspend;

    public MokkeryTransformer(@NotNull CompilerPluginScope compilerPluginScope) {
        Intrinsics.checkNotNullParameter((Object)compilerPluginScope, (String)"compilerPluginScope");
        super(compilerPluginScope);
        this.mockCache = CacheKt.Cache();
        this.spyCache = CacheKt.Cache();
        this.internalEvery = TransformerScopeApiKt.getFunction(this, Mokkery.Function.INSTANCE.getInternalEvery());
        this.internalEverySuspend = TransformerScopeApiKt.getFunction(this, Mokkery.Function.INSTANCE.getInternalEverySuspend());
        this.internalVerify = TransformerScopeApiKt.getFunction(this, Mokkery.Function.INSTANCE.getInternalVerify());
        this.internalVerifySuspend = TransformerScopeApiKt.getFunction(this, Mokkery.Function.INSTANCE.getInternalVerifySuspend());
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FqName name = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)expression.getSymbol().getOwner()));
        if (!FqNamesUtilKt.isSubpackageOf((FqName)name, (FqName)Mokkery.INSTANCE.getDev_mokkery())) {
            return super.visitCall(expression);
        }
        IrExpression result = super.visitCall(expression);
        FqName fqName = name;
        return Intrinsics.areEqual((Object)fqName, (Object)Mokkery.Name.INSTANCE.getMock()) ? this.replaceWithMock(expression) : (Intrinsics.areEqual((Object)fqName, (Object)Mokkery.Name.INSTANCE.getSpy()) ? this.replaceWithSpy(expression) : (Intrinsics.areEqual((Object)fqName, (Object)Mokkery.Name.INSTANCE.getEvery()) ? this.replaceWithInternalEvery(expression, this.internalEvery.getSymbol()) : (Intrinsics.areEqual((Object)fqName, (Object)Mokkery.Name.INSTANCE.getVerify()) ? this.replaceWithInternalVerify(expression, this.internalVerify.getSymbol()) : (Intrinsics.areEqual((Object)fqName, (Object)Mokkery.Name.INSTANCE.getEverySuspend()) ? this.replaceWithInternalEvery(expression, this.internalEverySuspend.getSymbol()) : (Intrinsics.areEqual((Object)fqName, (Object)Mokkery.Name.INSTANCE.getVerifySuspend()) ? this.replaceWithInternalVerify(expression, this.internalVerifySuspend.getSymbol()) : result)))));
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.mockCache.clear();
        this.spyCache.clear();
        return super.visitFile(declaration);
    }

    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        long time = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        IrModuleFragment result = super.visitModuleFragment(declaration);
        TransformerScope $this$mokkeryLog$iv = this;
        boolean $i$f$mokkeryLog = false;
        StringBuilder stringBuilder = new StringBuilder().append("dev.mokkery: ");
        CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
        MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryLog$iv);
        boolean bl = false;
        String string = "Plugin time: " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)time));
        MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)compilerMessageSeverity, (String)stringBuilder.append(string).toString(), null, (int)4, null);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression replaceWithMock(IrCall call) {
        void $this$irCallConstructor$iv;
        IrClass irClass = this.getTypeToMock(call);
        if (irClass == null) {
            return (IrExpression)call;
        }
        IrClass klass = irClass;
        if (JsPlatformKt.isJs((TargetPlatform)this.getPluginContext().getPlatform()) && IrTypeKt.isAnyFunction((IrType)IrUtilsKt.getDefaultType((IrClass)klass))) {
            return CreateMockJsFunctionKt.createMockJsFunction(this, call, klass);
        }
        IrClass mockedClass2 = this.mockCache.getOrPut(klass, (Function0<IrClass>)((Function0)new Function0<IrClass>(this, klass){
            final /* synthetic */ MokkeryTransformer this$0;
            final /* synthetic */ IrClass $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final IrClass invoke() {
                return CreateMockClassKt.createMockClass(this.this$0, this.$klass);
            }
        }));
        TransformerScope $this$declarationIrBuilder_u24default$iv = this;
        IrGeneratorContext context$iv = (IrGeneratorContext)$this$declarationIrBuilder_u24default$iv.getPluginContext();
        boolean $i$f$declarationIrBuilder = false;
        DeclarationIrBuilder $this$replaceWithMock_u24lambda_u242 = new DeclarationIrBuilder(context$iv, (IrSymbol)call.getSymbol(), 0, 0, 12, null);
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$replaceWithMock_u24lambda_u242;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)mockedClass2);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructor constructor$iv = irConstructor;
        boolean $i$f$irCallConstructor = false;
        IrConstructorCall irConstructorCall = IrBuilderWithScopeKt.irCallConstructor((IrBuilderWithScope)$this$irCallConstructor$iv, constructor$iv);
        IrFunctionAccessExpression $this$replaceWithMock_u24lambda_u242_u24lambda_u241 = (IrFunctionAccessExpression)irConstructorCall;
        boolean bl2 = false;
        IrExpression irExpression = (IrExpression)CollectionsKt.getOrNull((List)IrJsUtilsKt.getValueArguments((IrFunctionAccessExpression)((IrFunctionAccessExpression)call)), (int)0);
        if (irExpression == null) {
            irExpression = (IrExpression)IrBuilderWithScopeKt.irGetEnumEntry((IrBuilderWithScope)$this$replaceWithMock_u24lambda_u242, TransformerScopeApiKt.getClass(this, Mokkery.Class.INSTANCE.getMockMode()), MokkeryConfigApiKt.getMockMode(this).toString());
        }
        IrExpression modeArg = irExpression;
        IrExpression block = (IrExpression)CollectionsKt.getOrNull((List)IrJsUtilsKt.getValueArguments((IrFunctionAccessExpression)((IrFunctionAccessExpression)call)), (int)1);
        $this$replaceWithMock_u24lambda_u242_u24lambda_u241.putValueArgument(0, modeArg);
        IrExpression irExpression2 = block;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$replaceWithMock_u24lambda_u242));
        }
        $this$replaceWithMock_u24lambda_u242_u24lambda_u241.putValueArgument(1, irExpression2);
        return (IrExpression)((IrFunctionAccessExpression)irConstructorCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression replaceWithSpy(IrCall call) {
        void $this$irCallConstructor$iv;
        IrClass irClass = this.getTypeToMock(call);
        if (irClass == null) {
            return (IrExpression)call;
        }
        IrClass klass = irClass;
        if (JsPlatformKt.isJs((TargetPlatform)this.getPluginContext().getPlatform()) && IrTypeKt.isAnyFunction((IrType)IrUtilsKt.getDefaultType((IrClass)klass))) {
            return CreateSpyJsFunctionKt.createSpyJsFunction(this, call, klass);
        }
        IrClass spiedClass2 = this.spyCache.getOrPut(klass, (Function0<IrClass>)((Function0)new Function0<IrClass>(this, klass){
            final /* synthetic */ MokkeryTransformer this$0;
            final /* synthetic */ IrClass $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final IrClass invoke() {
                return CreateSpyClassKt.createSpyClass(this.this$0, this.$klass);
            }
        }));
        TransformerScope $this$declarationIrBuilder_u24default$iv = this;
        IrGeneratorContext context$iv = (IrGeneratorContext)$this$declarationIrBuilder_u24default$iv.getPluginContext();
        boolean $i$f$declarationIrBuilder = false;
        DeclarationIrBuilder $this$replaceWithSpy_u24lambda_u244 = new DeclarationIrBuilder(context$iv, (IrSymbol)call.getSymbol(), 0, 0, 12, null);
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$replaceWithSpy_u24lambda_u244;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)spiedClass2);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructor constructor$iv = irConstructor;
        boolean $i$f$irCallConstructor = false;
        IrConstructorCall irConstructorCall = IrBuilderWithScopeKt.irCallConstructor((IrBuilderWithScope)$this$irCallConstructor$iv, constructor$iv);
        IrFunctionAccessExpression $this$replaceWithSpy_u24lambda_u244_u24lambda_u243 = (IrFunctionAccessExpression)irConstructorCall;
        boolean bl2 = false;
        $this$replaceWithSpy_u24lambda_u244_u24lambda_u243.putValueArgument(0, (IrExpression)IrJsUtilsKt.getValueArguments((IrFunctionAccessExpression)((IrFunctionAccessExpression)call)).get(0));
        return (IrExpression)((IrFunctionAccessExpression)irConstructorCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression replaceWithInternalEvery(IrCall expression, IrSimpleFunctionSymbol function) {
        void $this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246_u24lambda_u245;
        IrCall irCall2;
        void $this$irCall_u24default$iv;
        IrCall irCall3;
        void this_$iv$iv;
        IrExpression irExpression = expression.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression block = irExpression;
        if (!this.assertFunctionExpressionThatOriginatesLambda(block, expression.getSymbol())) {
            return (IrExpression)expression;
        }
        TransformerScope $this$declarationIrBuilder_u24default$iv = this;
        IrGeneratorContext context$iv = (IrGeneratorContext)$this$declarationIrBuilder_u24default$iv.getPluginContext();
        boolean $i$f$declarationIrBuilder = false;
        DeclarationIrBuilder $this$replaceWithInternalEvery_u24lambda_u247 = new DeclarationIrBuilder(context$iv, (IrSymbol)expression.getSymbol(), 0, 0, 12, null);
        boolean bl = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$replaceWithInternalEvery_u24lambda_u247;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246 = this_$iv$iv;
        boolean bl2 = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246;
        IrSimpleFunction func$iv = TransformerScopeApiKt.getFunction(this, Mokkery.Function.INSTANCE.getTemplatingScope());
        boolean $i$f$irCall = false;
        IrCall irCall4 = irCall3 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCall_u24default$iv, (IrSimpleFunctionSymbol)func$iv.getSymbol());
        IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246;
        boolean bl3 = false;
        IrCall $this$null = irCall4;
        IrVariable variable = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)irStatementsBuilder, (IrExpression)((IrExpression)irCall3), null, (boolean)false, null, null, (int)30, null);
        TemplatingScopeCallsTransformer transformer = new TemplatingScopeCallsTransformer(this, variable);
        block.transformChildren((IrElementTransformer)transformer, null);
        IrBuilderWithScope $this$irCall$iv = (IrBuilderWithScope)$this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246;
        boolean $i$f$irCall2 = false;
        irCall3 = irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCall$iv, (IrSimpleFunctionSymbol)function);
        irStatementsBuilder = $this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246;
        boolean bl4 = false;
        $this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246_u24lambda_u245.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246), (IrValueDeclaration)((IrValueDeclaration)variable)));
        $this$replaceWithInternalEvery_u24lambda_u247_u24lambda_u246_u24lambda_u245.putValueArgument(1, block);
        irStatementsBuilder.unaryPlus((IrStatement)irCall2);
        return (IrExpression)this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression replaceWithInternalVerify(IrCall expression, IrSimpleFunctionSymbol function) {
        void $this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
        IrCall irCall2;
        void $this$irCall_u24default$iv;
        IrCall irCall3;
        void this_$iv$iv;
        IrExpression mode = expression.getValueArgument(0);
        IrExpression irExpression = expression.getValueArgument(1);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression block = irExpression;
        if (!this.assertFunctionExpressionThatOriginatesLambda(block, expression.getSymbol())) {
            return (IrExpression)expression;
        }
        TransformerScope $this$declarationIrBuilder_u24default$iv = this;
        IrGeneratorContext context$iv = (IrGeneratorContext)$this$declarationIrBuilder_u24default$iv.getPluginContext();
        boolean $i$f$declarationIrBuilder = false;
        DeclarationIrBuilder $this$replaceWithInternalVerify_u24lambda_u2410 = new DeclarationIrBuilder(context$iv, (IrSymbol)expression.getSymbol(), 0, 0, 12, null);
        boolean bl = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$replaceWithInternalVerify_u24lambda_u2410;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249 = this_$iv$iv;
        boolean bl2 = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249;
        IrSimpleFunction func$iv = TransformerScopeApiKt.getFunction(this, Mokkery.Function.INSTANCE.getTemplatingScope());
        boolean $i$f$irCall = false;
        IrCall irCall4 = irCall3 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCall_u24default$iv, (IrSimpleFunctionSymbol)func$iv.getSymbol());
        IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249;
        boolean bl3 = false;
        IrCall $this$null = irCall4;
        IrVariable variable = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)irStatementsBuilder, (IrExpression)((IrExpression)irCall3), null, (boolean)false, null, null, (int)30, null);
        TemplatingScopeCallsTransformer transformer = new TemplatingScopeCallsTransformer(this, variable);
        block.transformChildren((IrElementTransformer)transformer, null);
        IrBuilderWithScope $this$irCall$iv = (IrBuilderWithScope)$this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249;
        boolean $i$f$irCall2 = false;
        irCall3 = irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCall$iv, (IrSimpleFunctionSymbol)function);
        irStatementsBuilder = $this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249;
        boolean bl4 = false;
        $this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249_u24lambda_u248.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249), (IrValueDeclaration)((IrValueDeclaration)variable)));
        IrExpression irExpression2 = mode;
        if (irExpression2 == null) {
            irExpression2 = this.irGetVerifyMode((IrBuilderWithScope)$this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249, MokkeryConfigApiKt.getVerifyMode(this));
        }
        $this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249_u24lambda_u248.putValueArgument(1, irExpression2);
        $this$replaceWithInternalVerify_u24lambda_u2410_u24lambda_u249_u24lambda_u248.putValueArgument(2, block);
        irStatementsBuilder.unaryPlus((IrStatement)irCall2);
        return (IrExpression)this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression irGetVerifyMode(IrBuilderWithScope $this$irGetVerifyMode, VerifyMode verifyMode) {
        IrDeclarationReference irDeclarationReference;
        if (verifyMode instanceof SoftVerifyMode) {
            void $this$irCallConstructor$iv;
            IrBuilderWithScope irBuilderWithScope = $this$irGetVerifyMode;
            IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)this.getIrClassOf(Reflection.getOrCreateKotlinClass(SoftVerifyMode.class)));
            Intrinsics.checkNotNull((Object)irConstructor);
            IrConstructor constructor$iv = irConstructor;
            boolean $i$f$irCallConstructor = false;
            IrConstructorCall irConstructorCall = IrBuilderWithScopeKt.irCallConstructor((IrBuilderWithScope)$this$irCallConstructor$iv, constructor$iv);
            IrFunctionAccessExpression $this$irGetVerifyMode_u24lambda_u2411 = (IrFunctionAccessExpression)irConstructorCall;
            boolean bl = false;
            $this$irGetVerifyMode_u24lambda_u2411.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$irGetVerifyMode, (int)((SoftVerifyMode)verifyMode).getAtLeast(), null, (int)2, null));
            $this$irGetVerifyMode_u24lambda_u2411.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$irGetVerifyMode, (int)((SoftVerifyMode)verifyMode).getAtMost(), null, (int)2, null));
            irDeclarationReference = (IrDeclarationReference)((IrFunctionAccessExpression)irConstructorCall);
        } else {
            irDeclarationReference = (IrDeclarationReference)IrBuilderKt.irGetObject((IrBuilderWithScope)$this$irGetVerifyMode, (IrClassSymbol)this.getIrClassOf(Reflection.getOrCreateKotlinClass(verifyMode.getClass())).getSymbol());
        }
        IrDeclarationReference expression = irDeclarationReference;
        return (IrExpression)expression;
    }

    private final IrClass getIrClassOf(KClass<?> cls) {
        IrPluginContext irPluginContext = this.getPluginContext();
        String string = cls.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        ClassId classId = ClassId.fromString((String)StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(...)");
        IrClassSymbol irClassSymbol = irPluginContext.referenceClass(classId);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return (IrClass)irClassSymbol.getOwner();
    }

    private final boolean assertFunctionExpressionThatOriginatesLambda(IrExpression $this$assertFunctionExpressionThatOriginatesLambda, IrSimpleFunctionSymbol function) {
        if (!($this$assertFunctionExpressionThatOriginatesLambda instanceof IrFunctionExpression)) {
            TransformerScope $this$mokkeryErrorAt$iv = this;
            boolean $i$f$mokkeryErrorAt = false;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryErrorAt$iv);
            boolean bl = false;
            String string = ((IrSimpleFunction)function.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String string2 = Mokkery.Errors.INSTANCE.notLambdaExpression(string, IrDeclarationKt.renderSymbol((IrDeclaration)CollectionsKt.last((List)((IrSimpleFunction)function.getOwner()).getValueParameters())));
            messageCollector.report(compilerMessageSeverity, string2, (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$assertFunctionExpressionThatOriginatesLambda, $this$mokkeryErrorAt$iv.getCurrentFile()));
            return false;
        }
        return true;
    }

    private final IrClass getTypeToMock(IrCall $this$getTypeToMock) {
        if (!this.checkInterceptionPossibilities($this$getTypeToMock)) {
            return null;
        }
        return IrTypesKt.getClass((IrType)$this$getTypeToMock.getType());
    }

    private final boolean checkInterceptionPossibilities(IrCall $this$checkInterceptionPossibilities) {
        TransformerScope $this$mokkeryErrorAt$iv;
        IrType irType;
        String name;
        block9: {
            IrType typeArg;
            block8: {
                IrType irType2;
                String string = ((IrSimpleFunction)$this$checkInterceptionPossibilities.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                name = string;
                typeArg = (IrType)CollectionsKt.firstOrNull((List)IrJsUtilsKt.getTypeArguments((IrFunctionAccessExpression)((IrFunctionAccessExpression)$this$checkInterceptionPossibilities)));
                if (typeArg == null) break block8;
                IrType it = irType2 = typeArg;
                boolean bl = false;
                Object object = irType = !IrTypeUtilsKt.isTypeParameter((IrType)it) ? irType2 : null;
                if (irType != null) break block9;
            }
            IrCall $this$checkInterceptionPossibilities_u24lambda_u2415 = $this$checkInterceptionPossibilities;
            boolean bl = false;
            TransformerScope $this$mokkeryErrorAt$iv2 = this;
            boolean $i$f$mokkeryErrorAt = false;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryErrorAt$iv2);
            boolean bl2 = false;
            IrType irType3 = typeArg;
            String string = irType3 != null ? RenderIrElementKt.render$default((IrType)irType3, null, (int)1, null) : null;
            if (string == null) {
                string = "";
            }
            String string2 = Mokkery.Errors.INSTANCE.indirectCall(string, name);
            messageCollector.report(compilerMessageSeverity, string2, (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$checkInterceptionPossibilities_u24lambda_u2415, $this$mokkeryErrorAt$iv2.getCurrentFile()));
            return false;
        }
        IrType typeToMock = irType;
        IrClass irClass = IrTypesKt.getClass((IrType)typeToMock);
        Intrinsics.checkNotNull((Object)irClass);
        IrClass classToMock = irClass;
        if (classToMock.getModality() == Modality.SEALED) {
            $this$mokkeryErrorAt$iv = this;
            boolean $i$f$mokkeryErrorAt = false;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryErrorAt$iv);
            boolean bl = false;
            String string = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)classToMock)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String string3 = Mokkery.Errors.INSTANCE.sealedTypeCannotBeIntercepted(string, name);
            messageCollector.report(compilerMessageSeverity, string3, (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$checkInterceptionPossibilities, $this$mokkeryErrorAt$iv.getCurrentFile()));
            return false;
        }
        if (classToMock.getModality() == Modality.FINAL) {
            $this$mokkeryErrorAt$iv = this;
            boolean $i$f$mokkeryErrorAt = false;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryErrorAt$iv);
            boolean bl = false;
            String string = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)classToMock)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String string4 = Mokkery.Errors.INSTANCE.finalTypeCannotBeIntercepted(string, name);
            messageCollector.report(compilerMessageSeverity, string4, (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$checkInterceptionPossibilities, $this$mokkeryErrorAt$iv.getCurrentFile()));
            return false;
        }
        if (!IrUtilsKt.isInterface((IrClass)classToMock) && IrUtilsKt.getDefaultConstructor((IrClass)classToMock) == null) {
            $this$mokkeryErrorAt$iv = this;
            boolean $i$f$mokkeryErrorAt = false;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryErrorAt$iv);
            boolean bl = false;
            String string = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)classToMock)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String string5 = Mokkery.Errors.INSTANCE.noDefaultConstructorTypeCannotBeIntercepted(string, name);
            messageCollector.report(compilerMessageSeverity, string5, (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$checkInterceptionPossibilities, $this$mokkeryErrorAt$iv.getCurrentFile()));
            return false;
        }
        Sequence nonOverridableFunctions2 = SequencesKt.filterNot((Sequence)IrUtilsKt.getFunctions((IrClass)classToMock), (Function1)((Function1)checkInterceptionPossibilities.nonOverridableFunctions.1.INSTANCE));
        Sequence nonOverridableProperties2 = SequencesKt.filterNot((Sequence)IrUtilsKt.getProperties((IrDeclarationContainer)((IrDeclarationContainer)classToMock)), (Function1)((Function1)checkInterceptionPossibilities.nonOverridableProperties.1.INSTANCE));
        if (SequencesKt.any((Sequence)nonOverridableProperties2) || SequencesKt.any((Sequence)nonOverridableFunctions2)) {
            TransformerScope $this$mokkeryErrorAt$iv3 = this;
            boolean $i$f$mokkeryErrorAt = false;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryErrorAt$iv3);
            boolean bl = false;
            Sequence names2 = SequencesKt.plus((Sequence)SequencesKt.map((Sequence)nonOverridableFunctions2, (Function1)checkInterceptionPossibilities.4.names.1.INSTANCE), (Sequence)SequencesKt.map((Sequence)nonOverridableProperties2, (Function1)checkInterceptionPossibilities.4.names.2.INSTANCE));
            String string = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)classToMock)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String string6 = Mokkery.Errors.INSTANCE.finalMembersTypeCannotBeIntercepted(string, name, SequencesKt.joinToString$default((Sequence)names2, null, null, null, (int)0, null, null, (int)63, null));
            messageCollector.report(compilerMessageSeverity, string6, (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$checkInterceptionPossibilities, $this$mokkeryErrorAt$iv3.getCurrentFile()));
            return false;
        }
        TransformerScope $this$mokkeryLogAt$iv = this;
        boolean $i$f$mokkeryLogAt = false;
        StringBuilder stringBuilder = new StringBuilder().append("dev.mokkery: ");
        CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
        MessageCollector messageCollector = TransformerScopeApiKt.getMessageCollector($this$mokkeryLogAt$iv);
        boolean bl = false;
        String string = "Recognized " + name + " call with type " + RenderIrElementKt.render$default((IrType)typeToMock, null, (int)1, null) + '!';
        messageCollector.report(compilerMessageSeverity, stringBuilder.append(string).toString(), (CompilerMessageSourceLocation)IrExpressionKt.locationInFile((IrElement)$this$checkInterceptionPossibilities, $this$mokkeryLogAt$iv.getCurrentFile()));
        return true;
    }
}

