//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering.autofill](../index.md)/[TypeRegistryAutofillProvider](index.md)

# TypeRegistryAutofillProvider

[common]\
interface [TypeRegistryAutofillProvider](index.md) : [AutofillProvider](../-autofill-provider/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; 

Allows registering value providers for specific types. This provider does not support polymorphism. If you register provider for some interface `A`, it provides a value only for `A::class`. Provider for `AImpl` must be registered separately.

## Functions

| Name | Summary |
|---|---|
| [provide](../-autofill-provider/provide.md) | [common]<br>abstract fun [provide](../-autofill-provider/provide.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [AutofillProvider.Value](../-autofill-provider/-value/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;<br>Returns an instance of [Value.Provided](../-autofill-provider/-value/-provided/index.md), whenever value of [type](../-autofill-provider/provide.md) can be provided. Otherwise, it returns [Value.Absent](../-autofill-provider/-value/-absent/index.md) |
| [provideValue](../provide-value.md) | [common]<br>inline fun &lt;[T](../provide-value.md)&gt; [AutofillProvider](../-autofill-provider/index.md)&lt;[T](../provide-value.md)&gt;.[provideValue](../provide-value.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [T](../provide-value.md)?<br>Calls [AutofillProvider.provide](../-autofill-provider/provide.md) and returns [AutofillProvider.Value.Provided.value](../-autofill-provider/-value/-provided/value.md) if present. |
| [register](register.md) | [common]<br>abstract fun &lt;[T](register.md)&gt; [register](register.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](register.md) &amp; [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, provider: () -&gt; [T](register.md)?)<br>Registers a [provider](register.md) for [type](register.md). It overwrites any provider registered for the same [type](register.md) with this method. |
| [register](../register.md) | [common]<br>inline fun &lt;[T](../register.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [TypeRegistryAutofillProvider](index.md).[register](../register.md)(noinline provider: () -&gt; [T](../register.md)?)<br>Calls [TypeRegistryAutofillProvider.register](register.md) with type [T](../register.md). |
| [unregister](unregister.md) | [common]<br>abstract fun [unregister](unregister.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;)<br>Unregisters provider registered with [register](register.md) for [type](unregister.md) so it is no longer in use. |
| [unregister](../unregister.md) | [common]<br>inline fun &lt;[T](../unregister.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [TypeRegistryAutofillProvider](index.md).[unregister](../unregister.md)()<br>Calls [TypeRegistryAutofillProvider.unregister](unregister.md) with type [T](../unregister.md). |
