//[mokkery-runtime](../../index.md)/[dev.mokkery](index.md)

# Package-level declarations

## Functions

| Name | Summary |
|---|---|
| [every](every.md) | [common]<br>fun &lt;[T](every.md)&gt; [every](every.md)(block: [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).() -&gt; [T](every.md)): [BlockingAnsweringScope](../dev.mokkery.answering/-blocking-answering-scope/index.md)&lt;[T](every.md)&gt;<br>Starts defining an answer for a **single** function call specified by [block](every.md). Returned scope allows defining answer. |
| [everySuspend](every-suspend.md) | [common]<br>fun &lt;[T](every-suspend.md)&gt; [everySuspend](every-suspend.md)(block: suspend [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).() -&gt; [T](every-suspend.md)): [SuspendAnsweringScope](../dev.mokkery.answering/-suspend-answering-scope/index.md)&lt;[T](every-suspend.md)&gt;<br>Just like [every](every.md), but allows suspendable function call. |
| [mock](mock.md) | [common]<br>inline fun &lt;[T](mock.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [mock](mock.md)(mode: MockMode = MokkeryCompilerDefaults.mockMode, block: [T](mock.md).() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }): [T](mock.md)<br>Provides mock implementation of given type [T](mock.md). |
| [resetAnswers](reset-answers.md) | [common]<br>fun [resetAnswers](reset-answers.md)(vararg mocks: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Removes all answers configured for given [mocks](reset-answers.md). |
| [resetCalls](reset-calls.md) | [common]<br>fun [resetCalls](reset-calls.md)(vararg mocks: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Clears call history for all given [mocks](reset-calls.md). |
| [spy](spy.md) | [common]<br>inline fun &lt;[T](spy.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [spy](spy.md)(obj: [T](spy.md)): [T](spy.md)<br>Returns given [obj](spy.md) wrapped with a spying implementation of [T](spy.md). |
| [verify](verify.md) | [common]<br>fun [verify](verify.md)(mode: VerifyMode = MokkeryCompilerDefaults.verifyMode, block: [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Asserts that calls sequence defined in [block](verify.md) satisfies given [mode](verify.md). |
| [verifyNoMoreCalls](verify-no-more-calls.md) | [common]<br>fun [verifyNoMoreCalls](verify-no-more-calls.md)(vararg mocks: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Asserts that all given [mocks](verify-no-more-calls.md) have all their registered calls verified with [verify](verify.md) or [verifySuspend](verify-suspend.md). |
| [verifySuspend](verify-suspend.md) | [common]<br>fun [verifySuspend](verify-suspend.md)(mode: VerifyMode = MokkeryCompilerDefaults.verifyMode, block: suspend [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Just like [verify](verify.md), but allows suspendable function calls. |
