//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[Answer](index.md)

# Answer

@DelicateMokkeryApi

interface [Answer](index.md)&lt;out [T](index.md)&gt;

An answer for a function call. For blocking answers only [call](call.md) implementation is required. For suspending answers [callSuspend](call-suspend.md) should be implemented and [call](call.md) implementation should throw an exception. Use [Suspending](-suspending/index.md) for convenience.

#### Inheritors

| |
|---|
| [Suspending](-suspending/index.md) |
| [Const](-const/index.md) |
| [Block](-block/index.md) |
| [Throws](-throws/index.md) |
| [Autofill](-autofill/index.md) |
| [Sequential](-sequential/index.md) |

## Types

| Name | Summary |
|---|---|
| [Autofill](-autofill/index.md) | [common]<br>object [Autofill](-autofill/index.md) : [Answer](index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; <br>Used whenever there is no defined answer for a call to mock that is in dev.mokkery.MockMode.autofill. Refer to [AutofillProvider.forMockMode](../../dev.mokkery.answering.autofill/-autofill-provider/-companion/for-mock-mode.md) to read more about returned values. |
| [Block](-block/index.md) | [common]<br>class [Block](-block/index.md)&lt;[T](-block/index.md)&gt;(val block: [BlockingCallDefinitionScope](../-blocking-call-definition-scope/index.md)&lt;[T](-block/index.md)&gt;.([CallArgs](../-call-args/index.md)) -&gt; [T](-block/index.md)) : [Answer](index.md)&lt;[T](-block/index.md)&gt; <br>Calls [block](-block/block.md) on [call](-block/call.md) and callSuspend. |
| [BlockSuspend](-block-suspend/index.md) | [common]<br>class [BlockSuspend](-block-suspend/index.md)&lt;[T](-block-suspend/index.md)&gt;(val block: suspend [SuspendCallDefinitionScope](../-suspend-call-definition-scope/index.md)&lt;[T](-block-suspend/index.md)&gt;.([CallArgs](../-call-args/index.md)) -&gt; [T](-block-suspend/index.md)) : [Answer.Suspending](-suspending/index.md)&lt;[T](-block-suspend/index.md)&gt; <br>Just like [Block](-block/index.md) but for suspending functions. |
| [Const](-const/index.md) | [common]<br>class [Const](-const/index.md)&lt;[T](-const/index.md)&gt;(val value: [T](-const/index.md)) : [Answer](index.md)&lt;[T](-const/index.md)&gt; <br>Returns [value](-const/value.md) on [call](-const/call.md) and callSuspend. |
| [Sequential](-sequential/index.md) | [common]<br>interface [Sequential](-sequential/index.md)&lt;[T](-sequential/index.md)&gt; : [Answer](index.md)&lt;[T](-sequential/index.md)&gt; <br>Interface for every answer that have to be called in repeat when specified in [sequentially](../sequentially.md). |
| [SequentialByIterator](-sequential-by-iterator/index.md) | [common]<br>class [SequentialByIterator](-sequential-by-iterator/index.md)&lt;[T](-sequential-by-iterator/index.md)&gt;(val iterator: [Iterator](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html)&lt;[Answer](index.md)&lt;[T](-sequential-by-iterator/index.md)&gt;&gt;) : [Answer.Sequential](-sequential/index.md)&lt;[T](-sequential-by-iterator/index.md)&gt; <br>Returns results of answers from [iterator](-sequential-by-iterator/iterator.md) until empty. It supports nested [Sequential](-sequential/index.md) answers and calls them until they are empty. |
| [Suspending](-suspending/index.md) | [common]<br>interface [Suspending](-suspending/index.md)&lt;[T](-suspending/index.md)&gt; : [Answer](index.md)&lt;[T](-suspending/index.md)&gt; <br>Convenience interface for custom suspending answers. By default, it throws runtime exception on [call](-suspending/call.md). |
| [Throws](-throws/index.md) | [common]<br>class [Throws](-throws/index.md)(val throwable: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)) : [Answer](index.md)&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt; <br>Throws [throwable](-throws/throwable.md) on [call](-throws/call.md) and callSuspend |

## Functions

| Name | Summary |
|---|---|
| [call](call.md) | [common]<br>abstract fun [call](call.md)(scope: [FunctionScope](../-function-scope/index.md)): [T](index.md)<br>Provides a return value for a function call with given [scope](call.md). |
| [callSuspend](call-suspend.md) | [common]<br>open suspend fun [callSuspend](call-suspend.md)(scope: [FunctionScope](../-function-scope/index.md)): [T](index.md)<br>Just like [call](call.md) but suspends. By default, it calls [call](call.md). |
