//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[AnsweringScope](index.md)

# AnsweringScope

interface [AnsweringScope](index.md)&lt;[T](index.md)&gt;

Scope for defining an answer for a function call.

#### Inheritors

| |
|---|
| [SuspendAnsweringScope](../-suspend-answering-scope/index.md) |
| [BlockingAnsweringScope](../-blocking-answering-scope/index.md) |
| [SequentialAnswerBuilder](../-sequential-answer-builder/index.md) |

## Functions

| Name | Summary |
|---|---|
| [answers](answers.md) | [common]<br>@DelicateMokkeryApi<br>abstract infix fun [answers](answers.md)(answer: [Answer](../-answer/index.md)&lt;[T](index.md)&gt;)<br>Registers given [answer](answers.md) for a function call. Direct usage requires care, because it allows to register suspending answer for non-suspend function. |
| [calls](../calls.md) | [common]<br>infix fun &lt;[T](../calls.md)&gt; [AnsweringScope](index.md)&lt;[T](../calls.md)&gt;.[calls](../calls.md)(superCall: [SuperCall](../-super-call/index.md))<br>Calls super method according to [SuperCall](../-super-call/index.md). |
| [returns](../returns.md) | [common]<br>infix fun &lt;[T](../returns.md)&gt; [AnsweringScope](index.md)&lt;[T](../returns.md)&gt;.[returns](../returns.md)(value: [T](../returns.md))<br>Function call always returns [value](../returns.md). |
| [sequentiallyReturns](../sequentially-returns.md) | [common]<br>infix fun &lt;[T](../sequentially-returns.md)&gt; [AnsweringScope](index.md)&lt;[T](../sequentially-returns.md)&gt;.[sequentiallyReturns](../sequentially-returns.md)(values: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[T](../sequentially-returns.md)&gt;)<br>Simplification for [sequentially](../sequentially.md) with multiple [returns](../returns.md) calls. |
| [sequentiallyThrows](../sequentially-throws.md) | [common]<br>infix fun &lt;[T](../sequentially-throws.md)&gt; [AnsweringScope](index.md)&lt;[T](../sequentially-throws.md)&gt;.[sequentiallyThrows](../sequentially-throws.md)(errors: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)&gt;)<br>Simplification for [sequentially](../sequentially.md) with multiple [throws](../throws.md) calls. |
| [throws](../throws.md) | [common]<br>infix fun &lt;[T](../throws.md)&gt; [AnsweringScope](index.md)&lt;[T](../throws.md)&gt;.[throws](../throws.md)(error: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html))<br>Function call always throws [error](../throws.md). |
| [throwsErrorWith](../throws-error-with.md) | [common]<br>infix fun &lt;[T](../throws-error-with.md)&gt; [AnsweringScope](index.md)&lt;[T](../throws-error-with.md)&gt;.[throwsErrorWith](../throws-error-with.md)(message: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Function call always throws an [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html) with given [message](../throws-error-with.md). |
