//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[BlockingCallDefinitionScope](index.md)

# BlockingCallDefinitionScope

[common]\
interface [BlockingCallDefinitionScope](index.md)&lt;out [R](index.md)&gt; : [CallDefinitionScope](../-call-definition-scope/index.md)&lt;[R](index.md)&gt; 

Provides a set of operation for [BlockingAnsweringScope.calls](../calls.md).

## Properties

| Name | Summary |
|---|---|
| [returnType](../-call-definition-scope/return-type.md) | [common]<br>abstract val [returnType](../-call-definition-scope/return-type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;<br>Mocked method return type [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html). |
| [self](../-call-definition-scope/self.md) | [common]<br>abstract val [self](../-call-definition-scope/self.md): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?<br>It serves as a `this` and returns mock object. |

## Functions

| Name | Summary |
|---|---|
| [callOriginal](call-original.md) | [common]<br>abstract fun [callOriginal](call-original.md)(): [R](index.md)<br>Calls original implementation of mocked method with original args. For interfaces, it is default implementation. |
| [callOriginalWith](call-original-with.md) | [common]<br>abstract fun [callOriginalWith](call-original-with.md)(vararg args: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [R](index.md)<br>Calls original implementation of mocked method with given [args](call-original-with.md). For interfaces, it is default implementation. |
| [callSuper](call-super.md) | [common]<br>abstract fun [callSuper](call-super.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [R](index.md)<br>Calls implementation of mocked method from super [type](call-super.md) with original args. For interfaces, it is default implementation of this [type](call-super.md). |
| [callSuperWith](call-super-with.md) | [common]<br>abstract fun [callSuperWith](call-super-with.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, vararg args: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [R](index.md)<br>Calls implementation of mocked method from super [type](call-super-with.md) with given [args](call-super-with.md). For interfaces, it is default implementation of this [type](call-super-with.md). |
| [self](../self.md) | [common]<br>inline fun &lt;[T](../self.md)&gt; [CallDefinitionScope](../-call-definition-scope/index.md)&lt;*&gt;.[self](../self.md)(): [T](../self.md)<br>Returns [CallDefinitionScope.self](../self.md) as [T](../self.md). |
