//[mokkery-runtime](../../index.md)/[dev.mokkery.answering](index.md)/[sequentially](sequentially.md)

# sequentially

[common]\
infix fun &lt;[T](sequentially.md)&gt; [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](sequentially.md)&gt;.[sequentially](sequentially.md)(block: [BlockingSequentialAnswerBuilder](-blocking-sequential-answer-builder/index.md)&lt;[T](sequentially.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))

Function call will answer sequentially with answers defined in [block](sequentially.md).

Example:

```kotlin
every { dependency.getString(any()) } sequentially {
   returns("1")
   returns("2")
}

x.getString("a") // returns "1"
x.getString("a") // returns "2"
x.getString("a") // fails with no more answers
```

[common]\
infix fun &lt;[T](sequentially.md)&gt; [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](sequentially.md)&gt;.[sequentially](sequentially.md)(block: [SuspendSequentialAnswerBuilder](-suspend-sequential-answer-builder/index.md)&lt;[T](sequentially.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))

Function call will answer sequentially with answers defined in [block](sequentially.md).

Example:

```kotlin
everySuspend { dependency.getString(any()) } sequentially {
   returns("1")
   returns("2")
}

x.getString("a") // returns "1"
x.getString("a") // returns "2"
x.getString("a") // fails with no more answers
```
