//[mokkery-runtime](../../index.md)/[dev.mokkery.matcher.capture](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [Capture](-capture/index.md) | [common]<br>interface [Capture](-capture/index.md)&lt;in [T](-capture/index.md)&gt;<br>Container for captured values. If [dev.mokkery.matcher.ArgMatcher](../dev.mokkery.matcher/-arg-matcher/index.md) implements this interface, [Capture.capture](-capture/capture.md) is called on full match (all matchers for given call match). Implementing [Capture](-capture/index.md) is not recommended. Use [CaptureMatcher](-capture-matcher/index.md). |
| [CaptureMatcher](-capture-matcher/index.md) | [common]<br>class [CaptureMatcher](-capture-matcher/index.md)&lt;[T](-capture-matcher/index.md)&gt;(capture: [Capture](-capture/index.md)&lt;[T](-capture-matcher/index.md)&gt;, matcher: [ArgMatcher](../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](-capture-matcher/index.md)&gt;? = null) : [ArgMatcher.Composite](../dev.mokkery.matcher/-arg-matcher/-composite/index.md)&lt;[T](-capture-matcher/index.md)&gt; <br>Matches an argument with matcher and captures arguments into [capture](-capture-matcher/capture.md). |
| [ContainerCapture](-container-capture/index.md) | [common]<br>interface [ContainerCapture](-container-capture/index.md)&lt;[T](-container-capture/index.md)&gt; : [Capture](-capture/index.md)&lt;[T](-container-capture/index.md)&gt; <br>A capture that is able to store elements. |
| [SlotCapture](-slot-capture/index.md) | [common]<br>interface [SlotCapture](-slot-capture/index.md)&lt;[T](-slot-capture/index.md)&gt; : [ContainerCapture](-container-capture/index.md)&lt;[T](-slot-capture/index.md)&gt; <br>[Capture](-capture/index.md) that stores only the last value. |

## Properties

| Name | Summary |
|---|---|
| [isAbsent](is-absent.md) | [common]<br>val &lt;[T](is-absent.md)&gt; [SlotCapture](-slot-capture/index.md)&lt;[T](is-absent.md)&gt;.[isAbsent](is-absent.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [SlotCapture.value](-slot-capture/value.md) is [SlotCapture.Value.Absent](-slot-capture/-value/-absent/index.md). |
| [isPresent](is-present.md) | [common]<br>val &lt;[T](is-present.md)&gt; [SlotCapture](-slot-capture/index.md)&lt;[T](is-present.md)&gt;.[isPresent](is-present.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [SlotCapture.value](-slot-capture/value.md) is [SlotCapture.Value.Present](-slot-capture/-value/-present/index.md). |

## Functions

| Name | Summary |
|---|---|
| [asCapture](as-capture.md) | [common]<br>fun &lt;[T](as-capture.md)&gt; [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](as-capture.md)&gt;.[asCapture](as-capture.md)(): [Capture](-capture/index.md)&lt;[T](as-capture.md)&gt;<br>Returns a [Capture](-capture/index.md) that stores values in this list. |
| [capture](capture.md) | [common]<br>inline fun &lt;[T](capture.md)&gt; [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[capture](capture.md)(container: [Capture](-capture/index.md)&lt;[T](capture.md)&gt;, matcher: [T](capture.md) = any()): [T](capture.md)<br>Matches an argument with [matcher](capture.md) and captures matching arguments into [capture](capture.md). Arguments are captured only if all other matchers match.<br>[common]<br>inline fun &lt;[T](capture.md)&gt; [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[capture](capture.md)(list: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](capture.md)&gt;, matcher: [T](capture.md) = any()): [T](capture.md)<br>Matches an argument with [matcher](capture.md) and captures matching arguments into [list](capture.md). Arguments are captured only if all other matchers match. |
| [get](get.md) | [common]<br>fun &lt;[T](get.md)&gt; [SlotCapture](-slot-capture/index.md)&lt;[T](get.md)&gt;.[get](get.md)(): [T](get.md)<br>Returns unwrapped [SlotCapture.value](-slot-capture/value.md) if it is [SlotCapture.Value.Present](-slot-capture/-value/-present/index.md). Otherwise, it fails. |
| [getIfPresent](get-if-present.md) | [common]<br>fun &lt;[T](get-if-present.md)&gt; [SlotCapture](-slot-capture/index.md)&lt;[T](get-if-present.md)&gt;.[getIfPresent](get-if-present.md)(): [T](get-if-present.md)?<br>Returns unwrapped [SlotCapture.value](-slot-capture/value.md) if it is [SlotCapture.Value.Present](-slot-capture/-value/-present/index.md). Otherwise, it returns null. |
| [getValue](get-value.md) | [common]<br>operator fun &lt;[T](get-value.md)&gt; [SlotCapture](-slot-capture/index.md)&lt;[T](get-value.md)&gt;.[getValue](get-value.md)(thisRef: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, property: [KProperty](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-property/index.html)&lt;*&gt;): [T](get-value.md)?<br>Just like [getIfPresent](get-if-present.md), but as a [getValue](get-value.md) operator. |
| [onArg](on-arg.md) | [common]<br>inline fun &lt;[T](on-arg.md)&gt; [ArgMatchersScope](../dev.mokkery.matcher/-arg-matchers-scope/index.md).[onArg](on-arg.md)(matcher: [T](on-arg.md) = any(), noinline block: ([T](on-arg.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): [T](on-arg.md)<br>Short for [capture](capture.md) with [Capture.callback](-capture/-companion/callback.md). |
| [propagateCapture](propagate-capture.md) | [common]<br>fun &lt;[T](propagate-capture.md)&gt; [ArgMatcher](../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](propagate-capture.md)&gt;.[propagateCapture](propagate-capture.md)(value: [T](propagate-capture.md))<br>fun &lt;[T](propagate-capture.md)&gt; [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ArgMatcher](../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](propagate-capture.md)&gt;&gt;.[propagateCapture](propagate-capture.md)(value: [T](propagate-capture.md))<br>Helper function to propagate capture for [dev.mokkery.matcher.ArgMatcher.Composite](../dev.mokkery.matcher/-arg-matcher/-composite/index.md). |
